/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.DatabaseAccountConfigurationProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.RequestChargeTracker;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressCache;
import com.microsoft.azure.documentdb.internal.directconnectivity.BarrierRequestHelper;
import com.microsoft.azure.documentdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReadResult;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReader;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.documentdb.internal.directconnectivity.TransportClient;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyWriter {
    private static final Logger logger = LoggerFactory.getLogger(ConsistencyWriter.class);
    private static final int MAX_NUMBER_OF_WRITE_BARRIER_READ_RETRIES = 30;
    private static final int DELAY_BETWEEN_WRITE_BARRIER_CALLS_IN_MS = 30;
    private static final int MAX_SHORT_BARRIER_RETRIES_FOR_MULTI_REGION = 4;
    private static final int SHORT_BARRIER_RETRY_INTERVAL_IN_MS_FOR_MULTI_REGION = 10;
    private final AddressCache writeAddressCache;
    private final AddressCache alternateWriteAddressCache;
    private final StoreReader storeReader;
    private final TransportClient transportClient;
    private final DatabaseAccountConfigurationProvider configurationProvider;
    private final AuthorizationTokenProvider authorizationTokenProvider;
    private final ExecutorService executorService;

    public ConsistencyWriter(AddressCache readAddressCache, AddressCache writeAddressCache, AddressCache alternateWriteAddressCache, TransportClient transportClient, DatabaseAccountConfigurationProvider configurationProvider, AuthorizationTokenProvider authorizationTokenProvider, ExecutorService executorService) {
        this.writeAddressCache = writeAddressCache;
        this.alternateWriteAddressCache = alternateWriteAddressCache;
        this.storeReader = new StoreReader(readAddressCache, writeAddressCache, alternateWriteAddressCache, transportClient, null, executorService);
        this.transportClient = transportClient;
        this.configurationProvider = configurationProvider;
        this.authorizationTokenProvider = authorizationTokenProvider;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreResponse write(DocumentServiceRequest request) throws DocumentClientException {
        String sessionToken = request.getHeaders().get("x-ms-session-token");
        try {
            request.getHeaders().remove("x-ms-session-token");
            StoreResponse storeResponse = this.writePrivate(request);
            return storeResponse;
        }
        finally {
            request.setOriginalSessionToken(sessionToken);
        }
    }

    private void startBackgroundAddressRefresh(DocumentServiceRequest request) {
        final DocumentServiceRequest requestFinal = request;
        try {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        requestFinal.setForceAddressRefresh(true);
                        ReplicatedResourceClient.resolvePrimaryUri(requestFinal, ConsistencyWriter.this.writeAddressCache);
                    }
                    catch (DocumentClientException e) {
                        logger.warn("Background refresh of the primary address failed with {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            logger.warn("Background refresh of the primary address failed with {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private StoreResponse writePrivate(DocumentServiceRequest request) throws DocumentClientException {
        if (request.getRequestChargeTracker() == null) {
            request.setRequestChargeTracker(new RequestChargeTracker());
        }
        if (request.getGlobalStrongWriteResponse() == null) {
            StoreResponse response;
            URI primaryUri = ReplicatedResourceClient.resolvePrimaryUri(request, !request.useAlternateWriteEndpoint() ? this.writeAddressCache : this.alternateWriteAddressCache);
            try {
                response = this.transportClient.invokeResourceOperation(primaryUri, request);
            }
            catch (DocumentClientException e) {
                String header;
                String string = header = e.getResponseHeaders() != null ? e.getResponseHeaders().get("x-ms-write-request-trigger-refresh") : null;
                if (StringUtils.isNotEmpty(header) && header.equalsIgnoreCase(String.valueOf(1))) {
                    this.startBackgroundAddressRefresh(request);
                }
                throw e;
            }
            if (this.isGlobalStrong(response)) {
                DocumentServiceRequest barrierRequest;
                long lsn = NumberUtils.toLong((String)response.getHeaderValue("lsn"), (long)-1L);
                long globalCommittedLsn = NumberUtils.toLong((String)response.getHeaderValue("x-ms-global-committed-lsn"), (long)-1L);
                if (lsn == -1L || globalCommittedLsn == -1L) {
                    logger.debug("ConsistencyWriter: LSN or GlobalCommittedLSN is not set for global strong request");
                    throw new DocumentClientException(410, "ConsistencyWriter: LSN or GlobalCommittedLSN is not set for global strong request");
                }
                request.setGlobalStrongWriteResponse(response);
                request.setGlobalCommittedSelectedLSN(lsn);
                if (globalCommittedLsn < lsn && !this.waitForWriteBarrier(barrierRequest = BarrierRequestHelper.create(request, this.authorizationTokenProvider), lsn)) {
                    logger.debug("ConsistencyWriter: Write barrier has not been met for global strong request. SelectedGlobalCommittedLSN: " + lsn);
                    throw new DocumentClientException(410, "ConsistencyWriter: Write barrier has not been met for global strong request.");
                }
            }
            return response;
        }
        DocumentServiceRequest barrierRequest = BarrierRequestHelper.create(request, this.authorizationTokenProvider);
        if (!this.waitForWriteBarrier(barrierRequest, request.getGlobalCommittedSelectedLSN())) {
            logger.debug("ConsistencyWriter: Write barrier has not been met for global strong request. SelectedGlobalCommittedLSN: " + request.getGlobalCommittedSelectedLSN());
            throw new DocumentClientException(410, "ConsistencyWriter: Write barrier has not been met for global strong request.");
        }
        return request.getGlobalStrongWriteResponse();
    }

    private boolean isGlobalStrong(StoreResponse response) {
        String headerValue;
        int numberOfReadRegions;
        return this.configurationProvider.getStoreConsistencyPolicy() == ConsistencyLevel.Strong && (numberOfReadRegions = Integer.parseInt(headerValue = response.getHeaderValue("x-ms-number-of-read-regions"))) > 0;
    }

    private boolean waitForWriteBarrier(DocumentServiceRequest request, long barrier) throws DocumentClientException {
        int writeBarrierRetryCount = 30;
        long maxGlobalCommittedLSNReceived = 0L;
        while (writeBarrierRetryCount-- > 0) {
            StoreReadResult response = this.storeReader.readEventual(request);
            if (response != null) {
                if (response.getGlobalCommittedLSN() >= barrier) {
                    return true;
                }
                if (maxGlobalCommittedLSNReceived < response.getGlobalCommittedLSN()) {
                    maxGlobalCommittedLSNReceived = response.getGlobalCommittedLSN();
                }
            }
            try {
                if (30 - writeBarrierRetryCount > 4) {
                    Thread.sleep(30L);
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Delay thread interrupted with exception: ", e);
            }
        }
        logger.trace("ConsistencyWriter: Highest global committed lsn received for write barrier call is " + maxGlobalCommittedLSNReceived);
        return false;
    }
}

