/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;

public class HttpClientFactory {
    public static boolean DISABLE_HOST_NAME_VERIFICATION = false;

    public static PoolingHttpClientConnectionManager createConnectionManager(int maxPoolSize, int idleConnectionTimeoutSecs, int requestTimeoutSecs) {
        PoolingHttpClientConnectionManager connectionManager = null;
        if (DISABLE_HOST_NAME_VERIFICATION) {
            PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(SSLContexts.createDefault(), (HostnameVerifier)new NoopHostnameVerifier());
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
            connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        } else {
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        connectionManager.setMaxTotal(maxPoolSize);
        connectionManager.setDefaultMaxPerRoute(maxPoolSize);
        connectionManager.setValidateAfterInactivity(idleConnectionTimeoutSecs * 1000);
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeoutSecs * 1000).setTcpNoDelay(true).build());
        return connectionManager;
    }

    public static HttpClient createHttpClient(HttpClientConnectionManager connectionManager, int requestTimeoutSeconds) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(connectionManager).disableAutomaticRetries().disableRedirectHandling().disableCookieManagement().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(requestTimeoutSeconds * 1000).setConnectTimeout(requestTimeoutSeconds * 1000).setConnectionRequestTimeout(requestTimeoutSeconds * 1000).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeoutSeconds * 1000).build());
        return httpClientBuilder.build();
    }
}

