/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.DatabaseAccountConfigurationProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.SessionContainer;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressCache;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressInformation;
import com.microsoft.azure.documentdb.internal.directconnectivity.ConsistencyReader;
import com.microsoft.azure.documentdb.internal.directconnectivity.ConsistencyWriter;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.documentdb.internal.directconnectivity.TransportClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

class ReplicatedResourceClient {
    static final boolean GLOBAL_STRONG_ENABLED = true;
    private SessionContainer sesionContainer;
    private ConsistencyReader consistencyReader;
    private ConsistencyWriter consistencyWriter;

    public ReplicatedResourceClient(AddressCache readAddressCache, AddressCache writeAddressCache, AddressCache alternateWriteAddressCache, SessionContainer sesionContainer, TransportClient transportClient, DatabaseAccountConfigurationProvider databaseAccountConfigurationProvider, AuthorizationTokenProvider authorizationTokenProvider, ExecutorService executorService) {
        this.sesionContainer = sesionContainer;
        this.consistencyReader = new ConsistencyReader(readAddressCache, writeAddressCache, alternateWriteAddressCache, this.sesionContainer, transportClient, databaseAccountConfigurationProvider, authorizationTokenProvider, executorService);
        this.consistencyWriter = new ConsistencyWriter(readAddressCache, writeAddressCache, alternateWriteAddressCache, transportClient, databaseAccountConfigurationProvider, authorizationTokenProvider, executorService);
    }

    public StoreResponse invoke(DocumentServiceRequest request) throws DocumentClientException {
        try {
            switch (request.getOperationType()) {
                case Create: 
                case Replace: 
                case Delete: 
                case ExecuteJavaScript: 
                case Upsert: 
                case Recreate: {
                    return this.consistencyWriter.write(request);
                }
                case Read: 
                case ReadFeed: 
                case Query: 
                case SqlQuery: 
                case Head: 
                case HeadFeed: {
                    return this.consistencyReader.read(request);
                }
            }
            throw new IllegalStateException("Unsupported operation type");
        }
        catch (DocumentClientException e) {
            if (e.getStatusCode() == 410 && (e.getSubStatusCode() == null || e.getSubStatusCode() != 1007)) {
                this.sesionContainer.clearToken(request);
            }
            throw e;
        }
    }

    static URI resolvePrimaryUri(DocumentServiceRequest request, AddressCache addressCache) throws DocumentClientException {
        AddressInformation[] replicaAddresses = ReplicatedResourceClient.resolveAddresses(request, addressCache);
        try {
            if (request.getDefaultReplicaIndex() != null) {
                if (request.getDefaultReplicaIndex() >= 0 && request.getDefaultReplicaIndex() < replicaAddresses.length) {
                    return new URI(replicaAddresses[request.getDefaultReplicaIndex()].getPhysicalUri());
                }
            } else {
                for (int i = 0; i < replicaAddresses.length; ++i) {
                    if (!replicaAddresses[i].isPrimary()) continue;
                    return new URI(replicaAddresses[i].getPhysicalUri());
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid replica address");
        }
        throw new DocumentClientException(410, "The requested resource is no longer available at the server.");
    }

    private static AddressInformation[] resolveAddresses(DocumentServiceRequest request, AddressCache addressCache) throws DocumentClientException {
        AddressInformation[] allResolvedAddresses = addressCache.resolve(request);
        ArrayList<AddressInformation> publicResolvedAddresses = new ArrayList<AddressInformation>();
        ArrayList<AddressInformation> internalResolvedAddresses = new ArrayList<AddressInformation>();
        for (int i = 0; i < allResolvedAddresses.length; ++i) {
            AddressInformation address = allResolvedAddresses[i];
            if (StringUtils.isEmpty((CharSequence)address.getPhysicalUri())) continue;
            if (address.isPublic()) {
                publicResolvedAddresses.add(address);
                continue;
            }
            internalResolvedAddresses.add(address);
        }
        if (internalResolvedAddresses.size() > 0) {
            AddressInformation[] result = new AddressInformation[internalResolvedAddresses.size()];
            internalResolvedAddresses.toArray(result);
            return result;
        }
        AddressInformation[] result = new AddressInformation[publicResolvedAddresses.size()];
        publicResolvedAddresses.toArray(result);
        return result;
    }

    String getLastReadAddress() {
        return this.consistencyReader.getLastReadAddress();
    }

    void setLastReadAddress(String lastReadAddress) {
        this.consistencyReader.setLastReadAddress(lastReadAddress);
    }
}

