/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.DatabaseAccountConfigurationProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.RetryRequestDelegate;
import com.microsoft.azure.documentdb.internal.RetryUtility;
import com.microsoft.azure.documentdb.internal.SessionContainer;
import com.microsoft.azure.documentdb.internal.SessionTokenHelper;
import com.microsoft.azure.documentdb.internal.StoreModel;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressCache;
import com.microsoft.azure.documentdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.documentdb.internal.directconnectivity.TransportClient;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

public class ServerStoreModel
implements StoreModel {
    private final SessionContainer sessionContainer;
    private final ReplicatedResourceClient replicatedResourceClient;
    private Integer defaultReplicaIndex;
    private boolean forceAddressRefresh;

    public ServerStoreModel(TransportClient transportClient, AddressCache readAddressCache, AddressCache writeAddressCache, AddressCache alternateWriteAddressCache, SessionContainer sessionContainer, DatabaseAccountConfigurationProvider databaseAccountConfigurationProvider, AuthorizationTokenProvider authorizationTokenProvider, ExecutorService executorService) {
        this.sessionContainer = sessionContainer;
        this.replicatedResourceClient = new ReplicatedResourceClient(readAddressCache, writeAddressCache, alternateWriteAddressCache, sessionContainer, transportClient, databaseAccountConfigurationProvider, authorizationTokenProvider, executorService);
    }

    public Integer getDefaultReplicaIndex() {
        return this.defaultReplicaIndex;
    }

    public void setDefaultReplicaIndex(int defaultReplicaIndex) {
        this.defaultReplicaIndex = defaultReplicaIndex;
    }

    public String getLastReadAddress() {
        return this.replicatedResourceClient.getLastReadAddress();
    }

    public void setLastReadAddress(String lastReadAddress) {
        this.replicatedResourceClient.setLastReadAddress(lastReadAddress);
    }

    public boolean isForceAddressRefresh() {
        return this.forceAddressRefresh;
    }

    public void setForceAddressRefresh(boolean forceAddressRefresh) {
        this.forceAddressRefresh = forceAddressRefresh;
    }

    @Override
    public DocumentServiceResponse processMessage(final DocumentServiceRequest request) throws DocumentClientException {
        String consistency;
        if (this.defaultReplicaIndex != null) {
            request.setDefaultReplicaIndex(this.defaultReplicaIndex);
        }
        if (StringUtils.isNotEmpty((CharSequence)(consistency = request.getHeaders().get("x-ms-consistency-level")))) {
            try {
                request.setOriginalRequestConsistencyLevel(ConsistencyLevel.valueOf(consistency));
            }
            catch (IllegalArgumentException e) {
                throw new DocumentClientException(400, "InvalidHeaderValue ConsistencyLevel " + consistency);
            }
        }
        if (request.isReadingFromMaster()) {
            request.getHeaders().put("x-ms-consistency-level", ConsistencyLevel.Strong.name());
        }
        RetryRequestDelegate processDelegate = new RetryRequestDelegate(){

            @Override
            public DocumentServiceResponse apply(DocumentServiceRequest requestInner) throws DocumentClientException {
                StoreResponse storeResponse;
                try {
                    storeResponse = ServerStoreModel.this.replicatedResourceClient.invoke(requestInner);
                }
                catch (DocumentClientException dce) {
                    SessionTokenHelper.updateSession(ServerStoreModel.this.sessionContainer, request, dce);
                    throw dce;
                }
                return new DocumentServiceResponse(storeResponse);
            }
        };
        return RetryUtility.executeStoreClientRequest(processDelegate, request);
    }
}

