/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.routing;

import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.internal.AbstractDocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.AsyncCache;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.ResourceId;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionCache.class);
    private final AsyncCache<String, DocumentCollection> collectionInfoByNameCache;
    private final AsyncCache<String, DocumentCollection> collectionInfoByIdCache;

    CollectionCache(ExecutorService executorService) {
        this.collectionInfoByNameCache = new AsyncCache(executorService);
        this.collectionInfoByIdCache = new AsyncCache(executorService);
    }

    public DocumentCollection resolveCollection(AbstractDocumentServiceRequest request) {
        if (request.getIsNameBased()) {
            if (request.isForceNameCacheRefresh()) {
                this.refresh(request);
                request.setForceNameCacheRefresh(false);
            }
            if (request.getResolvedCollectionRid() == null) {
                DocumentCollection collectionInfo = this.resolveByName(request.getResourceAddress());
                request.setResolvedCollectionRid(collectionInfo.getResourceId());
                return collectionInfo;
            }
            return this.resolveByRid(request.getResolvedCollectionRid());
        }
        return this.resolveByRid(request.getResourceAddress());
    }

    private void refresh(AbstractDocumentServiceRequest request) {
        final String resourceFullName = PathsHelper.getCollectionPath(request.getResourceAddress());
        final CollectionCache collectionCache = this;
        if (request.getResolvedCollectionRid() != null) {
            DocumentCollection obsoleteValue = new DocumentCollection();
            obsoleteValue.setResourceId(request.getResolvedCollectionRid());
            try {
                LOGGER.trace("Getting collection info by name from cache {}, obsoleteValue: {}", (Object)resourceFullName, (Object)obsoleteValue);
                this.collectionInfoByNameCache.get(resourceFullName, obsoleteValue, new Callable<DocumentCollection>(){

                    @Override
                    public DocumentCollection call() throws Exception {
                        DocumentCollection collection = collectionCache.getByName(resourceFullName);
                        collectionCache.collectionInfoByIdCache.put(collection.getResourceId(), collection);
                        return collection;
                    }
                }).get();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.refresh(request.getResourceAddress());
        }
        request.setResolvedCollectionRid(null);
    }

    public void refresh(String resourceAddress) {
        if (PathsHelper.isNameBased(resourceAddress)) {
            final String resourceFullName = PathsHelper.getCollectionPath(resourceAddress);
            final CollectionCache collectionCache = this;
            this.collectionInfoByNameCache.refresh(resourceFullName, new Callable<DocumentCollection>(){

                @Override
                public DocumentCollection call() throws Exception {
                    DocumentCollection collection = collectionCache.getByName(resourceFullName);
                    collectionCache.collectionInfoByIdCache.put(collection.getResourceId(), collection);
                    return collection;
                }
            });
        }
    }

    private DocumentCollection resolveByRid(String resourceId) {
        ResourceId resourceIdParsed = ResourceId.parse(resourceId);
        final String collectionResourceId = resourceIdParsed.getDocumentCollectionId().toString();
        final CollectionCache collectionCache = this;
        try {
            LOGGER.trace("Resolving collection info by Rid {}, obsoleteValue: {}", (Object)collectionResourceId, null);
            return this.collectionInfoByIdCache.get(collectionResourceId, null, new Callable<DocumentCollection>(){

                @Override
                public DocumentCollection call() throws Exception {
                    return collectionCache.getByRid(collectionResourceId);
                }
            }).get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public DocumentCollection resolveByName(final String resourceAddress) {
        String resourceFullName = PathsHelper.getCollectionPath(resourceAddress);
        final CollectionCache collectionCache = this;
        try {
            LOGGER.trace("Resolving collection info by Name {}, obsoleteValue: {}", (Object)resourceFullName, null);
            return this.collectionInfoByNameCache.get(resourceFullName, null, new Callable<DocumentCollection>(){

                @Override
                public DocumentCollection call() throws Exception {
                    DocumentCollection collection = collectionCache.getByName(resourceAddress);
                    collectionCache.collectionInfoByIdCache.put(collection.getResourceId(), collection);
                    return collection;
                }
            }).get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract DocumentCollection getByRid(String var1);

    protected abstract DocumentCollection getByName(String var1);
}

