/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.routing;

import com.microsoft.azure.documentdb.ChangeFeedOptions;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedResponse;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.internal.AsyncCache;
import com.microsoft.azure.documentdb.internal.PathInfo;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.routing.CollectionRoutingMap;
import com.microsoft.azure.documentdb.internal.routing.InMemoryCollectionRoutingMap;
import com.microsoft.azure.documentdb.internal.routing.Range;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionKeyRangeCache
implements RoutingMapProvider {
    private static final Logger logger = LoggerFactory.getLogger(PartitionKeyRangeCache.class);
    private final DocumentQueryClientInternal client;
    private final AsyncCache<String, CollectionRoutingMap> routingMapCache;

    public PartitionKeyRangeCache(DocumentQueryClientInternal client) {
        this.client = client;
        this.routingMapCache = new AsyncCache(client.getExecutorService());
    }

    @Override
    public Collection<PartitionKeyRange> getOverlappingRanges(String collectionSelfLink, Range<String> range, boolean forceRefresh) {
        if (StringUtils.isEmpty((CharSequence)collectionSelfLink)) {
            throw new IllegalArgumentException("collectionSelfLink cannot be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("range cannot be null");
        }
        CollectionRoutingMap routingMap = this.tryLookUp(collectionSelfLink, null);
        if (forceRefresh && routingMap != null) {
            logger.debug("Request triggers force refresh on the PartitionKeyRangeCache. collectionLink {}, range {}", (Object)collectionSelfLink, (Object)range.toJson());
            routingMap = this.tryLookUp(collectionSelfLink, routingMap);
        }
        if (routingMap == null) {
            return Collections.emptyList();
        }
        return routingMap.getOverlappingRanges(range);
    }

    private CollectionRoutingMap tryLookUp(final String collectionLink, final CollectionRoutingMap previousValue) {
        try {
            logger.debug("Try looking up routing map for collection {}, obsoleteValue: {} stack {}", (Object)collectionLink, (Object)previousValue);
            Future<CollectionRoutingMap> future = this.routingMapCache.get(collectionLink, previousValue, new Callable<CollectionRoutingMap>(){

                @Override
                public CollectionRoutingMap call() {
                    return PartitionKeyRangeCache.this.getRoutingMapForCollection(collectionLink, previousValue);
                }
            });
            if (future != null) {
                return future.get();
            }
            logger.warn("There is no routing map lookup task for collection {}", (Object)collectionLink);
        }
        catch (InterruptedException e) {
            logger.warn("InterruptedException while trying to look up CollectionRoutingMap", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.warn("ExecutionException while trying to look up CollectionRoutingMap", (Throwable)e);
        }
        return null;
    }

    @Override
    public PartitionKeyRange getPartitionKeyRangeById(String collectionSelfLink, String partitionKeyRangeId, boolean forceRefresh) {
        if (StringUtils.isEmpty((CharSequence)collectionSelfLink)) {
            throw new IllegalArgumentException("collectionSelfLink cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)partitionKeyRangeId)) {
            throw new IllegalArgumentException("partitionKeyRangeId cannot be null");
        }
        CollectionRoutingMap routingMap = this.tryLookUp(collectionSelfLink, null);
        if (forceRefresh && routingMap != null) {
            routingMap = this.tryLookUp(collectionSelfLink, routingMap);
        }
        if (routingMap == null) {
            return null;
        }
        return routingMap.getRangeByPartitionKeyRangeId(partitionKeyRangeId);
    }

    @Override
    public PartitionKeyRange tryGetRangeByEffectivePartitionKey(String collectionSelfLink, String effectivePartitionKey) {
        Collection<PartitionKeyRange> ranges = this.getOverlappingRanges(collectionSelfLink, Range.getPointRange(effectivePartitionKey), false);
        if (ranges == null) {
            return null;
        }
        return ranges.iterator().next();
    }

    private CollectionRoutingMap getRoutingMapForCollection(String collectionLink, CollectionRoutingMap previousRoutingMap) {
        logger.trace("Getting routing map for collection {}", (Object)collectionLink);
        ChangeFeedOptions options = new ChangeFeedOptions();
        if (previousRoutingMap == null) {
            options.setStartFromBeginning(true);
        } else {
            options.setRequestContinuation(previousRoutingMap.getChangeFeedNextIfNoneMatch());
        }
        FeedResponse<PartitionKeyRange> deltaRangesResponse = this.client.readPartitionKeyRangesChangeFeed(collectionLink, options);
        List ranges = PartitionKeyRangeCache.discardGoneRanges(deltaRangesResponse.getQueryIterable());
        CollectionRoutingMap routingMap = null;
        if (previousRoutingMap == null) {
            PathInfo pathInfo = PathsHelper.parsePathSegments(collectionLink);
            if (pathInfo == null) {
                throw new IllegalArgumentException("CollectionLink is not valid");
            }
            routingMap = InMemoryCollectionRoutingMap.tryCreateCompleteRoutingMap(ranges, pathInfo.resourceIdOrFullName);
        } else {
            logger.debug("Combining partition key range cache with {} ranges change", (Object)ranges.size());
            routingMap = previousRoutingMap.combine(ranges, deltaRangesResponse.getResponseContinuation());
        }
        if (routingMap == null) {
            throw new IllegalStateException("Cannot create complete routing map");
        }
        return routingMap;
    }

    static List<ImmutablePair<PartitionKeyRange, Boolean>> discardGoneRanges(Iterable<PartitionKeyRange> ranges) {
        HashMap<String, ImmutablePair> rangesMap = new HashMap<String, ImmutablePair>();
        for (PartitionKeyRange range : ranges) {
            if (range == null) continue;
            if (range.getParents() != null) {
                rangesMap.keySet().removeAll(range.getParents());
            }
            rangesMap.put(range.getId(), new ImmutablePair((Object)range, (Object)true));
        }
        return new ArrayList<ImmutablePair<PartitionKeyRange, Boolean>>(rangesMap.values());
    }
}

