/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ExcludedPath;
import com.microsoft.azure.documentdb.IncludedPath;
import com.microsoft.azure.documentdb.Index;
import com.microsoft.azure.documentdb.IndexingMode;
import com.microsoft.azure.documentdb.JsonSerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.text.WordUtils;
import org.json.JSONObject;

public final class IndexingPolicy
extends JsonSerializable {
    private static final String DEFAULT_PATH = "/*";
    private Collection<IncludedPath> includedPaths;
    private Collection<ExcludedPath> excludedPaths;

    public IndexingPolicy() {
        this.setAutomatic(true);
        this.setIndexingMode(IndexingMode.Consistent);
    }

    public IndexingPolicy(Index[] defaultIndexOverrides) {
        this();
        if (defaultIndexOverrides == null) {
            throw new IllegalArgumentException("defaultIndexOverrides is null.");
        }
        IncludedPath includedPath = new IncludedPath();
        includedPath.setPath(DEFAULT_PATH);
        includedPath.setIndexes(new ArrayList<Index>(Arrays.asList(defaultIndexOverrides)));
        this.getIncludedPaths().add(includedPath);
    }

    public IndexingPolicy(String jsonString) {
        super(jsonString);
    }

    public IndexingPolicy(JSONObject jsonObject) {
        super(jsonObject);
    }

    public Boolean getAutomatic() {
        return super.getBoolean("automatic");
    }

    public void setAutomatic(boolean automatic) {
        super.set("automatic", automatic);
    }

    public IndexingMode getIndexingMode() {
        IndexingMode result = IndexingMode.Lazy;
        try {
            result = IndexingMode.valueOf(WordUtils.capitalize((String)super.getString("indexingMode")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("Invalid indexingMode value {}.", (Object)super.getString("indexingMode"));
        }
        return result;
    }

    public void setIndexingMode(IndexingMode indexingMode) {
        super.set("indexingMode", indexingMode.name());
    }

    public Collection<IncludedPath> getIncludedPaths() {
        if (this.includedPaths == null) {
            this.includedPaths = super.getCollection("includedPaths", IncludedPath.class);
            if (this.includedPaths == null) {
                this.includedPaths = new ArrayList<IncludedPath>();
            }
        }
        return this.includedPaths;
    }

    public void setIncludedPaths(Collection<IncludedPath> includedPaths) {
        this.includedPaths = includedPaths;
    }

    public Collection<ExcludedPath> getExcludedPaths() {
        if (this.excludedPaths == null) {
            this.excludedPaths = super.getCollection("excludedPaths", ExcludedPath.class);
            if (this.excludedPaths == null) {
                this.excludedPaths = new ArrayList<ExcludedPath>();
            }
        }
        return this.excludedPaths;
    }

    public void setExcludedPaths(Collection<ExcludedPath> excludedPaths) {
        this.excludedPaths = excludedPaths;
    }

    @Override
    void populatePropertyBag() {
        if (this.getIndexingMode() != IndexingMode.None && this.getIncludedPaths().size() == 0 && this.getExcludedPaths().size() == 0) {
            IncludedPath includedPath = new IncludedPath();
            includedPath.setPath(DEFAULT_PATH);
            this.getIncludedPaths().add(includedPath);
        }
        if (this.includedPaths != null) {
            for (IncludedPath includedPath : this.includedPaths) {
                includedPath.populatePropertyBag();
            }
            super.set("includedPaths", this.includedPaths);
        }
        if (this.excludedPaths != null) {
            for (ExcludedPath excludedPath : this.excludedPaths) {
                excludedPath.populatePropertyBag();
            }
            super.set("excludedPaths", this.excludedPaths);
        }
    }
}

