/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.RequestChargeTracker;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.VectorSessionToken;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReadResult;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeIdentity;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class AbstractDocumentServiceRequest {
    private final String resourceId;
    private final ResourceType resourceType;
    private final String path;
    private final Map<String, String> headers;
    private volatile String continuation;
    private boolean isMedia = false;
    private final boolean isNameBased;
    private final OperationType operationType;
    private final String resourceAddress;
    private volatile boolean forceNameCacheRefresh;
    private volatile boolean forceAddressRefresh;
    private volatile VectorSessionToken sessionToken;
    private volatile URI endpointOverride = null;
    private final String activityId;
    private volatile RequestChargeTracker requestChargeTracker;
    private volatile String resourceFullName;
    private volatile StoreReadResult quorumSelectedStoreResponse;
    private volatile long quorumSelectedLSN;
    private volatile long globalCommittedSelectedLSN;
    private volatile StoreResponse globalStrongWriteResponse;
    private volatile ConsistencyLevel originalRequestConsistencyLevel;
    private volatile String originalSessionToken;
    private volatile String resolvedCollectionRid;
    private volatile PartitionKeyRangeIdentity partitionKeyRangeIdentity;
    private volatile PartitionKeyRange resolvedPartitionKeyRange;
    private volatile Integer defaultReplicaIndex;
    private Boolean usePreferredLocations;
    private Integer locationIndexToRoute;
    private URI locationEndpointToRoute;
    private volatile boolean useWriteEndpoint;
    private volatile boolean useAlternateWriteEndpoint;
    private boolean shouldClearSessionTokenOnSessionReadFailure;

    protected AbstractDocumentServiceRequest(OperationType operationType, String resourceId, ResourceType resourceType, String path, Map<String, String> headers) {
        this.operationType = operationType;
        this.resourceType = resourceType;
        this.path = path;
        this.sessionToken = null;
        this.headers = headers != null ? headers : new HashMap();
        this.isNameBased = Utils.isNameBased(path);
        this.activityId = Utils.getTimeBasedRandomUUID().toString();
        if (!this.isNameBased) {
            this.resourceId = resourceType == ResourceType.Media ? AbstractDocumentServiceRequest.getAttachmentIdFromMediaId(resourceId) : resourceId;
            this.resourceAddress = resourceId;
        } else {
            this.resourceAddress = this.path;
            this.resourceId = null;
        }
    }

    protected static String extractIdFromUri(String str) {
        int separatorChar = 47;
        int len = str.length();
        if (len != 0 && str.charAt(len - 1) == '/') {
            --len;
        }
        if (len == 0) {
            return "";
        }
        int ridStartIndex = 1;
        int ridEndIndex = 0;
        boolean isResourceType = true;
        boolean resourceIdFound = false;
        for (int i = 1; i < len; ++i) {
            if (str.charAt(i) != '/') continue;
            resourceIdFound = true;
            boolean bl = isResourceType = !isResourceType;
            if (!isResourceType) {
                ridStartIndex = i + 1;
                continue;
            }
            ridEndIndex = i;
        }
        if (!resourceIdFound) {
            return "";
        }
        if (ridEndIndex <= ridStartIndex) {
            ridEndIndex = len;
        }
        return str.substring(ridStartIndex, ridEndIndex);
    }

    static String getAttachmentIdFromMediaId(String mediaId) {
        String attachmentId;
        byte[] buffer = Base64.decodeBase64((byte[])mediaId.replace('-', '/').getBytes());
        int resoureIdLength = 20;
        if (buffer.length > 20) {
            byte[] newBuffer = new byte[20];
            System.arraycopy(buffer, 0, newBuffer, 0, 20);
            attachmentId = Utils.encodeBase64String(newBuffer).replace('/', '-');
        } else {
            attachmentId = mediaId;
        }
        return attachmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public boolean getIsMedia() {
        return this.isMedia;
    }

    public void setIsMedia(boolean isMedia) {
        this.isMedia = isMedia;
    }

    public boolean getIsNameBased() {
        return this.isNameBased;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getResourceAddress() {
        return this.resourceAddress;
    }

    public boolean isForceNameCacheRefresh() {
        return this.forceNameCacheRefresh;
    }

    public void setForceNameCacheRefresh(boolean forceNameCacheRefresh) {
        this.forceNameCacheRefresh = forceNameCacheRefresh;
    }

    public boolean isForceAddressRefresh() {
        return this.forceAddressRefresh;
    }

    public void setForceAddressRefresh(boolean forceAddressRefresh) {
        this.forceAddressRefresh = forceAddressRefresh;
    }

    public VectorSessionToken getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(VectorSessionToken sessionToken) {
        this.sessionToken = sessionToken;
    }

    public URI getEndpointOverride() {
        return this.endpointOverride;
    }

    public void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride = endpointOverride;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public RequestChargeTracker getRequestChargeTracker() {
        return this.requestChargeTracker;
    }

    public void setRequestChargeTracker(RequestChargeTracker requestChargeTracker) {
        this.requestChargeTracker = requestChargeTracker;
    }

    public String getResourceFullName() {
        if (this.isNameBased) {
            String trimmedPath = Utils.trimBeginingAndEndingSlashes(this.path);
            String[] segments = StringUtils.split((String)trimmedPath, (char)'/');
            if (segments.length % 2 == 0) {
                if (Utils.IsResourceType(segments[segments.length - 2])) {
                    this.resourceFullName = trimmedPath;
                }
            } else if (Utils.IsResourceType(segments[segments.length - 1])) {
                this.resourceFullName = trimmedPath.substring(0, trimmedPath.lastIndexOf("/"));
            }
        } else {
            this.resourceFullName = this.getResourceId().toLowerCase();
        }
        return this.resourceFullName;
    }

    public String getResolvedCollectionRid() {
        return this.resolvedCollectionRid;
    }

    public void setResolvedCollectionRid(String resolvedCollectionRid) {
        this.resolvedCollectionRid = resolvedCollectionRid;
    }

    public PartitionKeyRangeIdentity getPartitionKeyRangeIdentity() {
        return this.partitionKeyRangeIdentity;
    }

    public void routeTo(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.setPartitionKeyRangeIdentity(partitionKeyRangeIdentity);
    }

    public void setPartitionKeyRangeIdentity(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.partitionKeyRangeIdentity = partitionKeyRangeIdentity;
        if (partitionKeyRangeIdentity != null) {
            this.headers.put("x-ms-documentdb-partitionkeyrangeid", partitionKeyRangeIdentity.toHeader());
        } else {
            this.headers.remove("x-ms-documentdb-partitionkeyrangeid");
        }
    }

    public PartitionKeyRange getResolvedPartitionKeyRange() {
        return this.resolvedPartitionKeyRange;
    }

    public void setResolvedPartitionKeyRange(PartitionKeyRange resolvedPartitionKeyRange) {
        this.resolvedPartitionKeyRange = resolvedPartitionKeyRange;
    }

    public long getQuorumSelectedLSN() {
        return this.quorumSelectedLSN;
    }

    public void setQuorumSelectedLSN(long quorumSelectedLSN) {
        this.quorumSelectedLSN = quorumSelectedLSN;
    }

    public ConsistencyLevel getOriginalRequestConsistencyLevel() {
        return this.originalRequestConsistencyLevel;
    }

    public void setOriginalRequestConsistencyLevel(ConsistencyLevel originalRequestConsistencyLevel) {
        this.originalRequestConsistencyLevel = originalRequestConsistencyLevel;
    }

    public StoreResponse getGlobalStrongWriteResponse() {
        return this.globalStrongWriteResponse;
    }

    public void setGlobalStrongWriteResponse(StoreResponse globalStrongWriteResponse) {
        this.globalStrongWriteResponse = globalStrongWriteResponse;
    }

    public long getGlobalCommittedSelectedLSN() {
        return this.globalCommittedSelectedLSN;
    }

    public void setGlobalCommittedSelectedLSN(long globalCommittedSelectedLSN) {
        this.globalCommittedSelectedLSN = globalCommittedSelectedLSN;
    }

    public String getOriginalSessionToken() {
        return this.originalSessionToken;
    }

    public void setOriginalSessionToken(String originalSessionToken) {
        this.originalSessionToken = originalSessionToken;
    }

    public StoreReadResult getQuorumSelectedStoreResponse() {
        return this.quorumSelectedStoreResponse;
    }

    public void setQuorumSelectedStoreResponse(StoreReadResult quorumSelectedStoreResponse) {
        this.quorumSelectedStoreResponse = quorumSelectedStoreResponse;
    }

    public void setDefaultReplicaIndex(Integer defaultReplicaIndex) {
        this.defaultReplicaIndex = defaultReplicaIndex;
    }

    public Integer getDefaultReplicaIndex() {
        return this.defaultReplicaIndex;
    }

    public boolean isChangeFeedRequest() {
        return this.headers.containsKey("A-IM");
    }

    public boolean isWritingToMaster() {
        return this.operationType.isWriteOperation() && this.resourceType.isMasterResource();
    }

    public boolean isReadingFromMaster() {
        return this.resourceType == ResourceType.Offer || this.resourceType == ResourceType.Database || this.resourceType == ResourceType.User || this.resourceType == ResourceType.Permission || this.resourceType == ResourceType.Topology || this.resourceType == ResourceType.DatabaseAccount || this.resourceType == ResourceType.PartitionKeyRange || this.resourceType == ResourceType.DocumentCollection && (this.operationType == OperationType.ReadFeed || this.operationType == OperationType.Query || this.operationType == OperationType.SqlQuery);
    }

    public boolean isReadOnlyRequest() {
        return Utils.isReadOnlyOperation(this.operationType);
    }

    public boolean shouldClearSessionTokenOnSessionReadFailure() {
        return this.shouldClearSessionTokenOnSessionReadFailure;
    }

    public void setShouldClearSessionTokenOnSessionReadFailure(boolean value) {
        this.shouldClearSessionTokenOnSessionReadFailure = value;
    }

    public Boolean getUsePreferredLocations() {
        return this.usePreferredLocations;
    }

    public void setUsePreferredLocations(Boolean value) {
        this.usePreferredLocations = value;
    }

    public Integer getLocationIndexToRoute() {
        return this.locationIndexToRoute;
    }

    public void setLocationIndexToRoute(Integer value) {
        this.locationIndexToRoute = value;
    }

    public URI getLocationEndpointToRoute() {
        return this.locationEndpointToRoute;
    }

    public void setLocationEndpointToRoute(URI value) {
        this.locationEndpointToRoute = value;
    }

    public boolean useWriteEndpoint() {
        return this.useWriteEndpoint;
    }

    public void setUseWriteEndpoint(boolean useWriteEndpoint) {
        this.useWriteEndpoint = useWriteEndpoint;
    }

    public boolean useAlternateWriteEndpoint() {
        return this.useAlternateWriteEndpoint;
    }

    public void setUseAlternateWriteEndpoint(boolean value) {
        this.useAlternateWriteEndpoint = value;
    }

    public void routeToLocation(int locationIndex, boolean usePreferredLocations) {
        this.setLocationIndexToRoute(locationIndex);
        this.setUsePreferredLocations(usePreferredLocations);
        this.setLocationEndpointToRoute(null);
    }

    public void routeToLocation(URI locationEndpoint) {
        this.setLocationEndpointToRoute(locationEndpoint);
        this.setLocationIndexToRoute(null);
        this.setUsePreferredLocations(null);
    }

    public void clearRouteToLocation() {
        this.setLocationIndexToRoute(null);
        this.setLocationEndpointToRoute(null);
        this.setUsePreferredLocations(null);
    }
}

