/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.ErrorUtils;
import com.microsoft.azure.documentdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.documentdb.internal.SessionContainer;
import com.microsoft.azure.documentdb.internal.SessionTokenHelper;
import com.microsoft.azure.documentdb.internal.StoreModel;
import com.microsoft.azure.documentdb.internal.UserAgentContainer;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayProxy
implements StoreModel {
    private final Logger logger = LoggerFactory.getLogger(GatewayProxy.class);
    private Map<String, String> defaultHeaders = new HashMap<String, String>();
    private ConnectionPolicy connectionPolicy;
    private HttpClient httpClient;
    private HttpClient mediaHttpClient;
    private QueryCompatibilityMode queryCompatibilityMode;
    private EndpointManager globalEndpointManager;
    private SessionContainer sessionContainer;

    public GatewayProxy(ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, QueryCompatibilityMode queryCompatibilityMode, String masterKey, Map<String, String> resourceTokens, UserAgentContainer userAgentContainer, EndpointManager globalEndpointManager, HttpClient httpClient, HttpClient mediaHttpClient, SessionContainer sessionContainer) {
        this.defaultHeaders.put("Cache-Control", "no-cache");
        this.defaultHeaders.put("x-ms-version", "2018-06-18");
        if (userAgentContainer == null) {
            userAgentContainer = new UserAgentContainer();
        }
        this.defaultHeaders.put("User-Agent", userAgentContainer.getUserAgent());
        if (consistencyLevel != null) {
            this.defaultHeaders.put("x-ms-consistency-level", consistencyLevel.toString());
        }
        this.connectionPolicy = connectionPolicy;
        this.globalEndpointManager = globalEndpointManager;
        this.queryCompatibilityMode = queryCompatibilityMode;
        this.httpClient = httpClient;
        this.mediaHttpClient = mediaHttpClient;
        this.sessionContainer = sessionContainer;
    }

    public DocumentServiceResponse doCreate(DocumentServiceRequest request) throws DocumentClientException {
        return this.performPostRequest(request);
    }

    public DocumentServiceResponse doUpsert(DocumentServiceRequest request) throws DocumentClientException {
        return this.performPostRequest(request);
    }

    public DocumentServiceResponse doRead(DocumentServiceRequest request) throws DocumentClientException {
        return this.performGetRequest(request);
    }

    public DocumentServiceResponse doReplace(DocumentServiceRequest request) throws DocumentClientException {
        return this.performPutRequest(request);
    }

    public DocumentServiceResponse doDelete(DocumentServiceRequest request) throws DocumentClientException {
        return this.performDeleteRequest(request);
    }

    public DocumentServiceResponse doExecute(DocumentServiceRequest request) throws DocumentClientException {
        return this.performPostRequest(request);
    }

    public DocumentServiceResponse doReadFeed(DocumentServiceRequest request) throws DocumentClientException {
        return this.performGetRequest(request);
    }

    public DocumentServiceResponse doQuery(DocumentServiceRequest request) throws DocumentClientException {
        request.getHeaders().put("x-ms-documentdb-isquery", "true");
        switch (this.queryCompatibilityMode) {
            case SqlQuery: {
                request.getHeaders().put("Content-Type", "application/sql");
                break;
            }
            default: {
                request.getHeaders().put("Content-Type", "application/query+json");
            }
        }
        return this.performPostRequest(request);
    }

    private HttpClient getHttpClient(boolean isForMedia) {
        if (isForMedia) {
            return this.mediaHttpClient;
        }
        return this.httpClient;
    }

    private void fillHttpRequestBaseWithHeaders(Map<String, String> headers, HttpRequestBase httpBase) {
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            httpBase.setHeader(entry.getKey(), entry.getValue());
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpBase.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private DocumentServiceResponse performDeleteRequest(DocumentServiceRequest request) throws DocumentClientException {
        URI uri;
        URI rootUri = request.getEndpointOverride();
        if (rootUri == null) {
            rootUri = this.globalEndpointManager.resolveServiceEndpoint(request);
        }
        try {
            uri = new URI("https", null, rootUri.getHost(), rootUri.getPort(), request.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        HttpDelete httpDelete = new HttpDelete(uri);
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpRequestBase)httpDelete);
        this.addProxy((HttpRequestBase)httpDelete);
        HttpResponse response = null;
        try {
            this.logger.trace("Sending DELETE request to {}", (Object)uri);
            response = this.getHttpClient(request.getIsMedia()).execute((HttpUriRequest)httpDelete);
        }
        catch (HttpHostConnectException e) {
            httpDelete.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        catch (IOException e) {
            httpDelete.releaseConnection();
            throw new DocumentClientException(403, e);
        }
        catch (Exception e) {
            httpDelete.releaseConnection();
            throw e;
        }
        ErrorUtils.maybeThrowException(uri.getPath(), response, true, this.logger);
        httpDelete.releaseConnection();
        return new DocumentServiceResponse(response, request.getIsMedia());
    }

    private void addProxy(HttpRequestBase httpRequest) {
        if (this.connectionPolicy.getProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.connectionPolicy.getProxy()).build();
            httpRequest.setConfig(config);
        }
    }

    DocumentServiceResponse performGetRequest(DocumentServiceRequest request) throws DocumentClientException {
        URI uri;
        URI rootUri = request.getEndpointOverride();
        if (rootUri == null) {
            rootUri = request.getIsMedia() ? this.globalEndpointManager.getWriteEndpoint() : this.globalEndpointManager.resolveServiceEndpoint(request);
        }
        try {
            uri = new URI("https", null, rootUri.getHost(), rootUri.getPort(), request.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        HttpGet httpGet = new HttpGet(uri);
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpRequestBase)httpGet);
        this.addProxy((HttpRequestBase)httpGet);
        HttpResponse response = null;
        try {
            this.logger.trace("Sending GET request to {}", (Object)uri);
            response = this.getHttpClient(request.getIsMedia()).execute((HttpUriRequest)httpGet);
        }
        catch (SocketTimeoutException | ConnectTimeoutException e) {
            httpGet.releaseConnection();
            throw new DocumentClientException(408, (Exception)e);
        }
        catch (HttpHostConnectException e) {
            httpGet.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        catch (IOException e) {
            httpGet.releaseConnection();
            throw new DocumentClientException(403, e);
        }
        catch (Exception e) {
            httpGet.releaseConnection();
            throw e;
        }
        ErrorUtils.maybeThrowException(uri.getPath(), response, true, this.logger);
        return new DocumentServiceResponse(response, request.getIsMedia());
    }

    DocumentServiceResponse performPostRequest(DocumentServiceRequest request) throws DocumentClientException {
        URI uri;
        URI rootUri = request.getEndpointOverride();
        if (rootUri == null) {
            rootUri = this.globalEndpointManager.resolveServiceEndpoint(request);
        }
        try {
            uri = new URI("https", null, rootUri.getHost(), rootUri.getPort(), request.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        HttpPost httpPost = new HttpPost(uri);
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpRequestBase)httpPost);
        httpPost.setEntity(request.getBody());
        this.addProxy((HttpRequestBase)httpPost);
        HttpResponse response = null;
        try {
            this.logger.trace("Sending POST request to {}", (Object)uri);
            response = this.getHttpClient(request.getIsMedia()).execute((HttpUriRequest)httpPost);
        }
        catch (SocketTimeoutException | ConnectTimeoutException e) {
            httpPost.releaseConnection();
            throw new DocumentClientException(408, (Exception)e);
        }
        catch (HttpHostConnectException e) {
            httpPost.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        catch (IOException e) {
            httpPost.releaseConnection();
            throw new DocumentClientException(403, e);
        }
        catch (Exception e) {
            httpPost.releaseConnection();
            throw e;
        }
        ErrorUtils.maybeThrowException(uri.getPath(), response, true, this.logger);
        return new DocumentServiceResponse(response, request.getIsMedia());
    }

    DocumentServiceResponse performPutRequest(DocumentServiceRequest request) throws DocumentClientException {
        URI uri;
        URI rootUri = request.getEndpointOverride();
        if (rootUri == null) {
            rootUri = this.globalEndpointManager.resolveServiceEndpoint(request);
        }
        try {
            uri = new URI("https", null, rootUri.getHost(), rootUri.getPort(), request.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        HttpPut httpPut = new HttpPut(uri);
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpRequestBase)httpPut);
        httpPut.setEntity(request.getBody());
        this.addProxy((HttpRequestBase)httpPut);
        HttpResponse response = null;
        try {
            this.logger.trace("Sending PUT request to {}", (Object)uri);
            response = this.getHttpClient(request.getIsMedia()).execute((HttpUriRequest)httpPut);
        }
        catch (HttpHostConnectException e) {
            httpPut.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        catch (IOException e) {
            httpPut.releaseConnection();
            throw new DocumentClientException(403, e);
        }
        catch (Exception e) {
            httpPut.releaseConnection();
            throw e;
        }
        ErrorUtils.maybeThrowException(uri.getPath(), response, true, this.logger);
        return new DocumentServiceResponse(response, request.getIsMedia());
    }

    @Override
    public DocumentServiceResponse processMessage(DocumentServiceRequest request) throws DocumentClientException {
        DocumentServiceResponse response;
        try {
            switch (request.getOperationType()) {
                case Create: {
                    response = this.doCreate(request);
                    break;
                }
                case Upsert: {
                    response = this.doUpsert(request);
                    break;
                }
                case Delete: {
                    response = this.doDelete(request);
                    break;
                }
                case ExecuteJavaScript: {
                    response = this.doExecute(request);
                    break;
                }
                case Read: {
                    response = this.doRead(request);
                    break;
                }
                case ReadFeed: {
                    response = this.doReadFeed(request);
                    break;
                }
                case Replace: {
                    response = this.doReplace(request);
                    break;
                }
                case SqlQuery: 
                case Query: {
                    response = this.doQuery(request);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type " + (Object)((Object)request.getOperationType()));
                }
            }
        }
        catch (DocumentClientException dce) {
            SessionTokenHelper.updateSession(this.sessionContainer, request, dce);
            throw dce;
        }
        return response;
    }
}

