/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.ResourceId;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

class BarrierRequestHelper {
    BarrierRequestHelper() {
    }

    static DocumentServiceRequest create(DocumentServiceRequest request, AuthorizationTokenProvider authorizationTokenProvider) {
        String partitionKey;
        DocumentServiceRequest barrierRequest;
        if (request.isReadingFromMaster() || request.isWritingToMaster()) {
            barrierRequest = DocumentServiceRequest.create(OperationType.HeadFeed, null, ResourceType.Database, null);
        } else if (request.getIsNameBased()) {
            String collectionLink = PathsHelper.getCollectionPath(request.getResourceAddress());
            barrierRequest = DocumentServiceRequest.create(OperationType.Head, ResourceType.DocumentCollection, collectionLink, null);
        } else {
            barrierRequest = DocumentServiceRequest.create(OperationType.Head, ResourceId.parse(request.getResourceId()).getDocumentCollectionId().toString(), ResourceType.DocumentCollection, null);
        }
        String xDate = Utils.getCurrentTimeGMT();
        barrierRequest.getHeaders().put("x-ms-date", xDate);
        String token = authorizationTokenProvider.generateKeyAuthorizationSignature("HEAD", barrierRequest.getResourceAddress(), barrierRequest.getResourceType(), barrierRequest.getHeaders());
        try {
            barrierRequest.getHeaders().put("authorization", URLEncoder.encode(token, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported encoding", e);
        }
        barrierRequest.setForceAddressRefresh(request.isForceAddressRefresh());
        barrierRequest.setRequestChargeTracker(request.getRequestChargeTracker());
        if (request.getPartitionKeyRangeIdentity() != null) {
            barrierRequest.routeTo(request.getPartitionKeyRangeIdentity());
        }
        if ((partitionKey = request.getHeaders().get("x-ms-documentdb-partitionkey")) != null) {
            barrierRequest.getHeaders().put("x-ms-documentdb-partitionkey", partitionKey);
        }
        return barrierRequest;
    }
}

