/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptionsBase;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContextFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

final class MultiCollectionQueryExecutionContext<T extends Resource>
implements QueryExecutionContext<T> {
    private final List<QueryExecutionContext<T>> childQueryExecutionContexts = new ArrayList<QueryExecutionContext<T>>();
    private int currentChildQueryExecutionContextIndex = 0;
    private Map<String, String> responseHeaders;

    public MultiCollectionQueryExecutionContext(DocumentQueryClientInternal client, ResourceType resourceType, Class<T> classT, SqlQuerySpec querySpec, FeedOptionsBase options, Iterable<String> documentFeedLinks) {
        for (String collectionLink : documentFeedLinks) {
            String path = Utils.joinPath(collectionLink, "docs");
            this.childQueryExecutionContexts.add(QueryExecutionContextFactory.createQueryExecutionContext(client, resourceType, classT, querySpec, options, path));
        }
    }

    @Override
    public boolean hasNext() {
        while (this.currentChildQueryExecutionContextIndex < this.childQueryExecutionContexts.size() && !this.childQueryExecutionContexts.get(this.currentChildQueryExecutionContextIndex).hasNext()) {
            ++this.currentChildQueryExecutionContextIndex;
        }
        return this.currentChildQueryExecutionContextIndex < this.childQueryExecutionContexts.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next");
        }
        QueryExecutionContext<T> currentQueryExecutionContext = this.childQueryExecutionContexts.get(this.currentChildQueryExecutionContextIndex);
        Resource result = (Resource)currentQueryExecutionContext.next();
        this.responseHeaders = currentQueryExecutionContext.getResponseHeaders();
        return (T)result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public List<T> fetchNextBlock() throws DocumentClientException {
        if (!this.hasNext()) {
            return null;
        }
        QueryExecutionContext<T> currentQueryExecutionContext = this.childQueryExecutionContexts.get(this.currentChildQueryExecutionContextIndex);
        List<T> result = currentQueryExecutionContext.fetchNextBlock();
        this.responseHeaders = currentQueryExecutionContext.getResponseHeaders();
        return result;
    }

    @Override
    public void onNotifyStop() {
        for (QueryExecutionContext<T> context : this.childQueryExecutionContexts) {
            context.onNotifyStop();
        }
    }
}

