/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DatabaseAccount;
import com.microsoft.azure.documentdb.DatabaseAccountManagerInternal;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.LocationCache;
import com.microsoft.azure.documentdb.internal.AsyncCache;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GlobalEndpointManager
implements EndpointManager {
    private final DatabaseAccountManagerInternal client;
    private final Logger logger = LoggerFactory.getLogger(GlobalEndpointManager.class);
    private final boolean enableEndpointDiscovery;
    private final URI defaultEndpoint;
    private final Object refreshLock;
    private DocumentClient documentClient;
    private LocationCache locationCache;
    private Future endpointRefreshTaskFuture;
    private long backgroundRefreshLocationTimeIntervalInMS;
    private volatile boolean isRefreshing;
    private AsyncCache<String, DatabaseAccount> databaseAccountCache;

    public GlobalEndpointManager(final DocumentClient client) {
        this(new DatabaseAccountManagerInternal(){

            @Override
            public URI getServiceEndpoint() {
                return client.getServiceEndpoint();
            }

            @Override
            public DatabaseAccount getDatabaseAccountFromEndpoint(URI endpoint) throws DocumentClientException {
                return client.getDatabaseAccountFromEndpoint(endpoint);
            }

            @Override
            public ConnectionPolicy getConnectionPolicy() {
                return client.getConnectionPolicy();
            }
        });
        this.documentClient = client;
        this.databaseAccountCache = new AsyncCache(client.getExecutorService());
    }

    public GlobalEndpointManager(DatabaseAccountManagerInternal client) {
        this.client = client;
        this.enableEndpointDiscovery = client.getConnectionPolicy().getEnableEndpointDiscovery();
        Collection<String> preferredLocations = client.getConnectionPolicy().getPreferredLocations() != null ? Collections.unmodifiableCollection(client.getConnectionPolicy().getPreferredLocations()) : null;
        this.defaultEndpoint = client.getServiceEndpoint();
        this.backgroundRefreshLocationTimeIntervalInMS = this.getBackgroundRefreshLocationTimeIntervalInMS();
        this.locationCache = this.createLocationCache(preferredLocations, client.getServiceEndpoint(), this.enableEndpointDiscovery, client.getConnectionPolicy().isUsingMultipleWriteLocations(), this.backgroundRefreshLocationTimeIntervalInMS);
        this.isRefreshing = false;
        this.refreshLock = new Object();
    }

    long getBackgroundRefreshLocationTimeIntervalInMS() {
        return 300000L;
    }

    LocationCache createLocationCache(Collection<String> preferredLocations, URI serviceEndpoint, boolean enableEndpointDiscovery, boolean useMultipleWriteLocations, long defaultUnavailableLocationExpirationTime) {
        return new LocationCache(preferredLocations, serviceEndpoint, enableEndpointDiscovery, useMultipleWriteLocations, defaultUnavailableLocationExpirationTime);
    }

    @Override
    public URI getWriteEndpoint() {
        return this.locationCache.getWriteEndpoint();
    }

    @Override
    public URI getReadEndpoint() {
        return this.locationCache.getReadEndpoint();
    }

    @Override
    public List<String> getOrderedWriteEndpoints() {
        return this.locationCache.getOrderedWriteEndpoints();
    }

    @Override
    public List<String> getOrderedReadEndpoints() {
        return this.locationCache.getOrderedReadEndpoints();
    }

    @Override
    public DatabaseAccount getDatabaseAccountFromAnyEndpoint() {
        DatabaseAccount databaseAccount = null;
        try {
            databaseAccount = this.client.getDatabaseAccountFromEndpoint(this.defaultEndpoint);
        }
        catch (DocumentClientException e) {
            this.logger.warn("Failed to retrieve database account information. {}", (Object)e.toString());
        }
        Collection<String> preferredLocations = this.locationCache.getPreferredLocations();
        if (databaseAccount == null && preferredLocations != null && preferredLocations.size() > 0) {
            for (String regionName : preferredLocations) {
                URI regionalUri = this.getRegionalEndpoint(regionName);
                if (regionalUri == null) continue;
                try {
                    databaseAccount = this.client.getDatabaseAccountFromEndpoint(regionalUri);
                    break;
                }
                catch (DocumentClientException e) {
                    this.logger.warn("Failed to retrieve database account information. {}", (Object)e.toString());
                }
            }
        }
        return databaseAccount;
    }

    @Override
    public URI resolveServiceEndpoint(DocumentServiceRequest request) {
        return this.locationCache.resolveServiceEndpoint(request);
    }

    @Override
    public void markEndpointUnavailableForRead(URI endpoint) {
        this.locationCache.markCurrentLocationUnavailableForRead(endpoint);
    }

    @Override
    public void markEndpointUnavailableForWrite(URI endpoint) {
        this.locationCache.markCurrentLocationUnavailableForWrite(endpoint);
    }

    @Override
    public boolean canUseMultipleWriteLocations(DocumentServiceRequest request) {
        return this.locationCache.canUseMultipleWriteLocations(request);
    }

    @Override
    public void close() {
        if (this.endpointRefreshTaskFuture != null) {
            this.endpointRefreshTaskFuture.cancel(true);
        }
    }

    URI getRegionalEndpoint(String regionName) {
        if (StringUtils.isNotEmpty((CharSequence)regionName)) {
            String databaseAccountName = this.defaultEndpoint.getHost();
            int indexOfDot = this.defaultEndpoint.getHost().indexOf(46);
            if (indexOfDot >= 0) {
                databaseAccountName = databaseAccountName.substring(0, indexOfDot);
            }
            String regionalAccountName = databaseAccountName + "-" + regionName.replace(" ", "");
            String regionalUrl = this.defaultEndpoint.toString().replaceFirst(databaseAccountName, regionalAccountName);
            try {
                return new URI(regionalUrl);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void refreshEndpointList(DatabaseAccount databaseAccount, boolean forceRefresh) {
        if (forceRefresh) {
            DatabaseAccount refreshedDatabaseAccount = this.refreshDatabaseAccountInternal();
            this.locationCache.onDatabaseAccountRead(refreshedDatabaseAccount);
            return;
        }
        this.refreshEndpointList(databaseAccount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refreshEndpointList(DatabaseAccount databaseAccount) {
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.isRefreshing) {
                return;
            }
            this.isRefreshing = true;
        }
        try {
            this.refreshEndpointListPrivate(databaseAccount);
        }
        catch (Exception e) {
            this.isRefreshing = false;
            throw e;
        }
    }

    public synchronized void refreshEndpointListPrivate(DatabaseAccount databaseAccount) {
        LocationCache.CanRefreshInBackground canRefreshInBackground;
        if (databaseAccount != null) {
            this.logger.debug("Refreshing endpoints list");
            this.locationCache.onDatabaseAccountRead(databaseAccount);
        }
        if (this.locationCache.shouldRefreshEndpoints(canRefreshInBackground = new LocationCache.CanRefreshInBackground(false))) {
            if (databaseAccount == null && !canRefreshInBackground.getValue()) {
                this.logger.debug("Refreshing endpoints list");
                databaseAccount = this.refreshDatabaseAccountInternal();
                this.locationCache.onDatabaseAccountRead(databaseAccount);
            }
            this.startRefreshLocationTimer();
        } else {
            this.isRefreshing = false;
        }
    }

    public void startRefreshLocationTimer() {
        final GlobalEndpointManager that = this;
        this.endpointRefreshTaskFuture = this.documentClient.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(that.backgroundRefreshLocationTimeIntervalInMS);
                    DatabaseAccount databaseAccount = that.refreshDatabaseAccountInternal();
                    that.refreshEndpointListPrivate(databaseAccount);
                }
                catch (Exception e) {
                    GlobalEndpointManager.this.logger.warn("Preferred location background task was interrupted");
                    that.startRefreshLocationTimer();
                }
            }
        });
    }

    private DatabaseAccount refreshDatabaseAccountInternal() {
        final GlobalEndpointManager that = this;
        Callable<DatabaseAccount> fetchDatabaseAccount = new Callable<DatabaseAccount>(){

            @Override
            public DatabaseAccount call() throws Exception {
                return that.getDatabaseAccountFromAnyEndpoint();
            }
        };
        this.databaseAccountCache.refresh("", fetchDatabaseAccount);
        try {
            return this.databaseAccountCache.get("", null, fetchDatabaseAccount).get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

