/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DatabaseAccount;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.Error;
import com.microsoft.azure.documentdb.internal.DatabaseAccountConfigurationProvider;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.Utils;
import java.util.HashMap;

public class BaseDatabaseAccountConfigurationProvider
implements DatabaseAccountConfigurationProvider {
    private ConsistencyLevel desiredConsistencyLevel;
    private DatabaseAccount databaseAccount;
    private EndpointManager globalEndpointManager;

    public BaseDatabaseAccountConfigurationProvider(ConsistencyLevel desiredConsistencyLevel, EndpointManager globalEndpointManager) {
        this.desiredConsistencyLevel = desiredConsistencyLevel;
        this.globalEndpointManager = globalEndpointManager;
        this.databaseAccount = this.globalEndpointManager.getDatabaseAccountFromAnyEndpoint();
        this.globalEndpointManager.refreshEndpointList(this.databaseAccount);
    }

    @Override
    public ConsistencyLevel getStoreConsistencyPolicy() throws DocumentClientException {
        this.ensureDatabaseAccountInitialized();
        ConsistencyLevel databaseAccountConsistency = this.databaseAccount.getConsistencyPolicy().getDefaultConsistencyLevel();
        if (this.desiredConsistencyLevel == null) {
            return databaseAccountConsistency;
        }
        if (!Utils.isValidConsistency(databaseAccountConsistency, this.desiredConsistencyLevel)) {
            throw new IllegalArgumentException(String.format("ConsistencyLevel %1s specified in the request is invalid when service is configured with consistency level %2s. Ensure the request consistency level is not stronger than the service consistency level.", this.desiredConsistencyLevel.toString(), databaseAccountConsistency.toString()));
        }
        return this.desiredConsistencyLevel;
    }

    @Override
    public int getMaxReplicaSetSize() throws DocumentClientException {
        this.ensureDatabaseAccountInitialized();
        return this.databaseAccount.getReplicationPolicy().getMaxReplicaSetSize();
    }

    @Override
    public String getQueryEngineConfiguration() {
        try {
            this.ensureDatabaseAccountInitialized();
        }
        catch (DocumentClientException e) {
            throw new IllegalStateException(e);
        }
        return this.databaseAccount.get("queryEngineConfiguration").toString();
    }

    private void ensureDatabaseAccountInitialized() throws DocumentClientException {
        if (this.databaseAccount != null) {
            return;
        }
        this.initializeDatabaseAccount();
    }

    private synchronized void initializeDatabaseAccount() throws DocumentClientException {
        if (this.databaseAccount != null) {
            return;
        }
        this.databaseAccount = this.globalEndpointManager.getDatabaseAccountFromAnyEndpoint();
        this.globalEndpointManager.refreshEndpointList(this.databaseAccount);
        if (this.databaseAccount == null) {
            int statusCode = 503;
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("x-ms-substatus", Integer.toString(-1));
            throw new DocumentClientException(statusCode, new Error(Integer.toString(statusCode), "Database Account could not be retrieved. Please retry this operation."), responseHeaders);
        }
    }
}

