/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.ResourceResponse;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.EndpointDiscoveryRetryPolicy;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.PartitionKeyMismatchRetryPolicy;
import com.microsoft.azure.documentdb.internal.ResourceThrottleRetryPolicy;
import com.microsoft.azure.documentdb.internal.RetryCreateDocumentDelegate;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import com.microsoft.azure.documentdb.internal.RetryRequestDelegate;
import com.microsoft.azure.documentdb.internal.SessionReadRetryPolicy;
import com.microsoft.azure.documentdb.internal.directconnectivity.GoneAndRetryWithRetryPolicy;
import com.microsoft.azure.documentdb.internal.routing.ClientCollectionCache;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtility {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtility.class);

    public static DocumentServiceResponse executeDocumentClientRequest(RetryRequestDelegate delegate, DocumentClient documentClient, EndpointManager globalEndpointManager, DocumentServiceRequest request) throws DocumentClientException {
        DocumentServiceResponse response = null;
        EndpointDiscoveryRetryPolicy discoveryRetryPolicy = new EndpointDiscoveryRetryPolicy(documentClient.getConnectionPolicy(), globalEndpointManager, request);
        ResourceThrottleRetryPolicy throttleRetryPolicy = new ResourceThrottleRetryPolicy(documentClient.getConnectionPolicy().getRetryOptions().getMaxRetryAttemptsOnThrottledRequests(), documentClient.getConnectionPolicy().getRetryOptions().getMaxRetryWaitTimeInSeconds());
        SessionReadRetryPolicy sessionReadRetryPolicy = new SessionReadRetryPolicy(globalEndpointManager, request, documentClient.getConnectionPolicy().getEnableEndpointDiscovery());
        while (true) {
            try {
                logger.trace("Executing DocumentClientRequest {} {} {}", new Object[]{request.getOperationType(), request.getResourceType(), request.getActivityId()});
                response = delegate.apply(request);
            }
            catch (DocumentClientException e) {
                boolean retry;
                RetryPolicy retryPolicy = null;
                if (e.getStatusCode() == 403 && (e.getSubStatusCode() != null && (e.getSubStatusCode() == 3 || e.getSubStatusCode() == 1008) || e.getCause() instanceof IOException) || documentClient.getConnectionPolicy().getHandleServiceUnavailableFromProxy() && e.getStatusCode() == 503 && e.getResponseHeaders() != null && e.getResponseHeaders().get("x-ms-serviceversion") == null) {
                    retryPolicy = discoveryRetryPolicy;
                } else if (e.getStatusCode() == 429) {
                    retryPolicy = throttleRetryPolicy;
                } else if (e.getStatusCode() == 404 && e.getSubStatusCode() != null && e.getSubStatusCode() == 1002) {
                    retryPolicy = sessionReadRetryPolicy;
                }
                boolean bl = retry = retryPolicy != null && retryPolicy.shouldRetry(e);
                if (!retry) {
                    logger.trace("Execution encountered exception: {}, status code {} sub status code {}. Won't retry!", new Object[]{e.getMessage(), e.getStatusCode(), e.getSubStatusCode()});
                    throw e;
                }
                logger.trace("Execution encountered exception: {}, status code {} sub status code {}. Will retry in {}ms", new Object[]{e.getMessage(), e.getStatusCode(), e.getSubStatusCode(), retryPolicy.getRetryAfterInMilliseconds()});
                RetryUtility.delayForRetry(retryPolicy);
                continue;
            }
            break;
        }
        logger.trace("Executing DocumentClientRequest finished. {}", (Object)request.getActivityId());
        return response;
    }

    public static DocumentServiceResponse executeStoreClientRequest(RetryRequestDelegate delegate, DocumentServiceRequest request) throws DocumentClientException {
        DocumentServiceResponse response = null;
        GoneAndRetryWithRetryPolicy goneAndRetryWithRetryPolicy = new GoneAndRetryWithRetryPolicy(request);
        while (true) {
            try {
                logger.trace("Executing DocumentClientRequest {} {} {}", new Object[]{request.getOperationType(), request.getResourceType(), request.getActivityId()});
                response = delegate.apply(request);
            }
            catch (DocumentClientException e) {
                boolean retry;
                GoneAndRetryWithRetryPolicy retryPolicy = null;
                if (e.getStatusCode() == 449 || e.getStatusCode() == 410) {
                    retryPolicy = goneAndRetryWithRetryPolicy;
                }
                boolean bl = retry = retryPolicy != null && retryPolicy.shouldRetry(e);
                if (!retry) {
                    logger.trace("Execution encountered exception: {}, status code {} sub status code {}. Won't retry!", new Object[]{e.getMessage(), e.getStatusCode(), e.getSubStatusCode()});
                    throw e;
                }
                logger.trace("Execution encountered exception: {}, status code {} sub status code {}. Will retry in {}ms", new Object[]{e.getMessage(), e.getStatusCode(), e.getSubStatusCode(), retryPolicy.getRetryAfterInMilliseconds()});
                RetryUtility.delayForRetry(retryPolicy);
                continue;
            }
            break;
        }
        logger.trace("Executing DocumentClientRequest finished. {}", (Object)request.getActivityId());
        return response;
    }

    public static ResourceResponse<Document> executeCreateDocument(RetryCreateDocumentDelegate delegate, ClientCollectionCache clientCollectionCache, String resourcePath) throws DocumentClientException {
        ResourceResponse<Document> result = null;
        PartitionKeyMismatchRetryPolicy keyMismatchRetryPolicy = new PartitionKeyMismatchRetryPolicy(resourcePath, clientCollectionCache);
        while (true) {
            try {
                logger.trace("Executing createDocument {}", (Object)resourcePath);
                result = delegate.apply();
            }
            catch (DocumentClientException e) {
                boolean retry;
                RetryPolicy retryPolicy = null;
                if (e.getStatusCode() == 400 && e.getSubStatusCode() != null && e.getSubStatusCode() == 1001) {
                    retryPolicy = keyMismatchRetryPolicy;
                }
                boolean bl = retry = retryPolicy != null && retryPolicy.shouldRetry(e);
                if (!retry) {
                    logger.trace("Execution encountered exception: {}, status code {} sub status code {}. Won't retry!", new Object[]{e.getMessage(), e.getStatusCode(), e.getSubStatusCode()});
                    throw e;
                }
                logger.trace("Execution encountered exception: {}, status code {} sub status code {}. Will retry in {}ms", new Object[]{e.getMessage(), e.getStatusCode(), e.getSubStatusCode(), retryPolicy.getRetryAfterInMilliseconds()});
                RetryUtility.delayForRetry(retryPolicy);
                continue;
            }
            break;
        }
        logger.trace("Executing DocumentClientRequest finished. {}", (Object)resourcePath);
        return result;
    }

    private static void delayForRetry(RetryPolicy retryPolicy) {
        long delay = retryPolicy.getRetryAfterInMilliseconds();
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

