/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.RequestChargeTracker;
import com.microsoft.azure.documentdb.internal.VectorSessionToken;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;

public class StoreReadResult {
    private StoreResponse storeResponse;
    private DocumentClientException exception;
    private long LSN;
    VectorSessionToken sessionToken;
    private String partitionKeyRangeId;
    private long quorumAckedLSN;
    private long globalCommittedLSN;
    private long itemLSN;
    private long numberOfReadRegions;
    private double requestCharge;
    private int currentReplicaSetSize;
    private int currentWriteQuorum;
    private boolean isValid;
    private boolean isGoneException;
    private boolean isNotFoundException;

    public StoreReadResult(StoreResponse storeResponse, DocumentClientException exception, long lSN, String partitionKeyRangeId, long quorumAckedLSN, double requestCharge, int currentReplicaSetSize, int currentWriteQuorum, boolean isValid, long globalCommittedLSN, long numberOfReadRegions, long itemLSN, VectorSessionToken sessionToken) {
        this.storeResponse = storeResponse;
        this.exception = exception;
        this.LSN = lSN;
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.quorumAckedLSN = quorumAckedLSN;
        this.requestCharge = requestCharge;
        this.currentReplicaSetSize = currentReplicaSetSize;
        this.currentWriteQuorum = currentWriteQuorum;
        this.isValid = isValid;
        this.isGoneException = this.exception != null && this.exception.getStatusCode() == 410;
        this.isNotFoundException = this.exception != null && this.exception.getStatusCode() == 404;
        this.globalCommittedLSN = globalCommittedLSN;
        this.numberOfReadRegions = numberOfReadRegions;
        this.itemLSN = itemLSN;
        this.sessionToken = sessionToken;
    }

    public DocumentClientException getException() {
        return this.exception;
    }

    public long getLSN() {
        return this.LSN;
    }

    public void setLSN(long lSN) {
        this.LSN = lSN;
    }

    public VectorSessionToken getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(VectorSessionToken sessionToken) {
        this.sessionToken = sessionToken;
    }

    public long getGlobalCommittedLSN() {
        return this.globalCommittedLSN;
    }

    private void setGlobalCommittedLSN(long globalCommittedLSN) {
        this.globalCommittedLSN = globalCommittedLSN;
    }

    public long getItemLSN() {
        return this.itemLSN;
    }

    private void setItemLSN(long itemLSN) {
        this.itemLSN = itemLSN;
    }

    public long getNumberOfReadRegions() {
        return this.numberOfReadRegions;
    }

    private void setNumberOfReadRegions(long numberOfReadRegions) {
        this.numberOfReadRegions = numberOfReadRegions;
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    public void setPartitionKeyRangeId(String partitionKeyRangeId) {
        this.partitionKeyRangeId = partitionKeyRangeId;
    }

    public long getQuorumAckedLSN() {
        return this.quorumAckedLSN;
    }

    public void setQuorumAckedLSN(long quorumAckedLSN) {
        this.quorumAckedLSN = quorumAckedLSN;
    }

    public double getRequestCharge() {
        return this.requestCharge;
    }

    private void setRequestCharge(RequestChargeTracker chargeTracker) {
        if (this.exception != null) {
            this.exception.getResponseHeaders().put("x-ms-request-charge", Double.toString(chargeTracker.getTotalRequestCharge()));
        } else if (this.storeResponse.getResponseHeaderNames() != null) {
            for (int i = 0; i < this.storeResponse.getResponseHeaderNames().length; ++i) {
                if (!this.storeResponse.getResponseHeaderNames()[i].equals("x-ms-request-charge")) continue;
                this.storeResponse.getResponseHeaderValues()[i] = Double.toString(chargeTracker.getTotalRequestCharge());
            }
        }
    }

    public int getCurrentReplicaSetSize() {
        return this.currentReplicaSetSize;
    }

    public void setCurrentReplicaSetSize(int currentReplicaSetSize) {
        this.currentReplicaSetSize = currentReplicaSetSize;
    }

    public int getCurrentWriteQuorum() {
        return this.currentWriteQuorum;
    }

    public void setCurrentWriteQuorum(int currentWriteQuorum) {
        this.currentWriteQuorum = currentWriteQuorum;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean isGoneException() {
        return this.isGoneException;
    }

    public void setGoneException(boolean isGoneException) {
        this.isGoneException = isGoneException;
    }

    public boolean isNotFoundException() {
        return this.isNotFoundException;
    }

    public void setNotFoundException(boolean isNotFoundException) {
        this.isNotFoundException = isNotFoundException;
    }

    public StoreResponse toStoreResponse(RequestChargeTracker chargeTracker) throws DocumentClientException {
        if (!this.isValid) {
            if (this.exception == null) {
                throw new DocumentClientException(500, "Unknown server error occurred when processing this request.");
            }
            throw this.exception;
        }
        if (chargeTracker != null) {
            this.setRequestCharge(chargeTracker);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.storeResponse;
    }
}

