/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Scanner;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResponse {
    static final Logger LOGGER = LoggerFactory.getLogger(StoreResponse.class);
    private final int status;
    private final String[] responseHeaderNames;
    private final String[] responseHeaderValues;
    private final InputStream httpEntityStream;
    private volatile String httpEntityContent;

    public StoreResponse(String[] responseHeaderNames, String[] responseHeaderValues, int status, HttpEntity responseBody, boolean isMedia) {
        this(responseHeaderNames, responseHeaderValues, status, responseBody != null ? StoreResponse.asInputStream(responseBody, isMedia) : null);
    }

    public StoreResponse(String[] responseHeaderNames, String[] responseHeaderValues, int status, InputStream inputStream) {
        this.responseHeaderNames = responseHeaderNames;
        this.responseHeaderValues = responseHeaderValues;
        this.status = status;
        this.httpEntityStream = inputStream;
    }

    public int getStatus() {
        return this.status;
    }

    public String[] getResponseHeaderNames() {
        return this.responseHeaderNames;
    }

    public String[] getResponseHeaderValues() {
        return this.responseHeaderValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseBody() {
        if (this.httpEntityContent == null) {
            if (this.httpEntityStream == null) {
                return null;
            }
            StoreResponse storeResponse = this;
            synchronized (storeResponse) {
                if (this.httpEntityContent != null) {
                    return this.httpEntityContent;
                }
                Scanner s = new Scanner(this.httpEntityStream, Charsets.UTF_8.toString()).useDelimiter("\\A");
                this.httpEntityContent = s.hasNext() ? s.next() : "";
            }
        }
        return this.httpEntityContent;
    }

    public InputStream getResponseStream() {
        return this.httpEntityStream;
    }

    private static InputStream asInputStream(HttpEntity responseBody, boolean isMedia) {
        try {
            if (isMedia && responseBody.isStreaming()) {
                return responseBody.getContent();
            }
            byte[] ba = EntityUtils.toByteArray((HttpEntity)responseBody);
            return new ByteArrayInputStream(ba);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public long getLSN() {
        String lsnString = this.getHeaderValue("lsn");
        if (StringUtils.isNotEmpty((CharSequence)lsnString)) {
            return Long.parseLong(lsnString);
        }
        return -1L;
    }

    public String getPartitionKeyRangeId() {
        return this.getHeaderValue("x-ms-documentdb-partitionkeyrangeid");
    }

    public String getContinuation() {
        return this.getHeaderValue("x-ms-continuation");
    }

    public String getHeaderValue(String attribute) {
        if (this.responseHeaderValues == null || this.responseHeaderNames.length != this.responseHeaderValues.length) {
            return null;
        }
        for (int i = 0; i < this.responseHeaderNames.length; ++i) {
            if (!this.responseHeaderNames[i].equalsIgnoreCase(attribute)) continue;
            return this.responseHeaderValues[i];
        }
        return null;
    }

    public static StoreResponse fromHttpResponse(HttpResponse httpResponse, boolean isMedia) {
        Header[] allHeaders = httpResponse.getAllHeaders();
        String[] headers = new String[allHeaders.length];
        String[] values = new String[allHeaders.length];
        for (int i = 0; i < allHeaders.length; ++i) {
            headers[i] = allHeaders[i].getName();
            if (headers[i].equals("x-ms-alt-content-path")) {
                try {
                    values[i] = URLDecoder.decode(allHeaders[i].getValue(), "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Unable to decode exception." + e.getMessage());
                }
            }
            values[i] = allHeaders[i].getValue();
        }
        StoreResponse storeResponse = new StoreResponse(headers, values, httpResponse.getStatusLine().getStatusCode(), httpResponse.getEntity(), isMedia);
        if (!isMedia) {
            try {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to consume HttpResponse.", e);
            }
        }
        return storeResponse;
    }
}

