/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.ChangeFeedOptions;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.FeedOptionsBase;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.ServiceJNIWrapper;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.query.AbstractQueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.routing.CollectionCache;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternalHelper;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.documentdb.internal.routing.PartitionRoutingHelper;
import com.microsoft.azure.documentdb.internal.routing.Range;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;

final class DefaultQueryExecutionContext<T extends Resource>
extends AbstractQueryExecutionContext<T> {
    private final Queue<T> buffer = new ArrayDeque<T>();
    private PartitionedQueryExecutionInfo queryExecutionInfo;
    private List<Range<String>> providedRanges;
    private DocumentCollection collection;
    private DocumentServiceResponse prefetchedResponse;
    private String partitionKeyRangeId;
    private boolean isChangeFeedRequest;

    public DefaultQueryExecutionContext(DocumentQueryClientInternal client, ResourceType resourceType, Class<T> classT, SqlQuerySpec querySpec, PartitionedQueryExecutionInfo queryExecutionInfo, FeedOptionsBase options, String resourceLink) {
        super(client, resourceType, classT, querySpec, options, resourceLink);
        ChangeFeedOptions changeFeedOptions = options instanceof ChangeFeedOptions ? (ChangeFeedOptions)options : null;
        this.partitionKeyRangeId = changeFeedOptions != null ? changeFeedOptions.getPartitionKeyRangeId() : ((FeedOptions)options).getPartitionKeyRangeIdInternal();
        this.queryExecutionInfo = queryExecutionInfo;
        this.isChangeFeedRequest = options instanceof ChangeFeedOptions;
    }

    @Override
    public List<T> fetchNextBlock() throws DocumentClientException {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(this.buffer);
        this.buffer.clear();
        return result;
    }

    @Override
    public boolean hasNext() {
        try {
            this.fillBuffer();
        }
        catch (DocumentClientException e) {
            throw new IllegalStateException(e);
        }
        return !this.buffer.isEmpty();
    }

    @Override
    public T next() {
        if (this.buffer.isEmpty()) {
            throw new NoSuchElementException("next");
        }
        return (T)((Resource)this.buffer.poll());
    }

    @Override
    public void onNotifyStop() {
    }

    private void fillBuffer() throws DocumentClientException {
        while (super.hasNextInternal() && this.buffer.isEmpty()) {
            DocumentServiceResponse response = null;
            if (!this.isChangeFeedRequest || this.prefetchedResponse == null) {
                response = this.executeOnce();
            } else {
                response = this.prefetchedResponse;
                this.prefetchedResponse = null;
            }
            this.processResponse(response);
            if (!this.isChangeFeedRequest || !super.hasNextInternal()) continue;
            this.prefetchedResponse = this.executeOnce();
            this.prefetchedStatusCode = this.prefetchedResponse.getStatusCode();
        }
    }

    private void processResponse(DocumentServiceResponse response) {
        this.responseHeaders = response.getResponseHeaders();
        List queryResponse = response.getQueryResponse(this.classT);
        this.buffer.addAll(queryResponse);
    }

    private DocumentServiceResponse executeOnce() throws DocumentClientException {
        String partitionKey;
        DocumentServiceRequest request = this.partitionKeyRangeId != null ? super.createRequest(this.getFeedHeaders(this.options), this.querySpec, this.partitionKeyRangeId) : super.createRequest(this.getFeedHeaders(this.options), this.querySpec, this.getPartitionKeyInternal());
        String continuationToken = super.getContinuationToken();
        if (continuationToken != null) {
            request.getHeaders().put(!this.isChangeFeedRequest ? "x-ms-continuation" : "If-None-Match", continuationToken);
        }
        if (!StringUtils.isEmpty((CharSequence)(partitionKey = request.getHeaders().get("x-ms-documentdb-partitionkey"))) || !this.resourceType.isPartitioned()) {
            return this.executeRequest(request);
        }
        if (this.partitionKeyRangeId != null) {
            String partitionKeyRangeId = request.getHeaders().get("x-ms-documentdb-partitionkeyrangeid");
            if (!StringUtils.isEmpty((CharSequence)partitionKeyRangeId)) {
                return this.executeRequest(request);
            }
            throw new IllegalStateException("For partitioned collection, PartitionKeyRangeId must be specified.");
        }
        if (this.collection == null) {
            this.collection = this.client.getCollectionCache().resolveCollection(request);
        }
        if (!Utils.isCollectionPartitioned(this.collection).booleanValue()) {
            request.routeTo(new PartitionKeyRangeIdentity(this.collection.getResourceId(), "0"));
            return this.executeRequest(request);
        }
        if (!ServiceJNIWrapper.isServiceJNIAvailable() && this.shouldExecuteQuery()) {
            return this.executeRequest(request);
        }
        Range<String> rangeFromContinuationToken = PartitionRoutingHelper.extractPartitionKeyRangeFromContinuationToken(request.getHeaders());
        RoutingMapProvider routingMapProvider = this.client.getPartitionKeyRangeCache();
        CollectionCache collectionCache = this.client.getCollectionCache();
        this.populateProvidedRanges(request);
        PartitionKeyRange targetPartitionKeyRange = this.tryGetTargetPartitionKeyRange(rangeFromContinuationToken);
        if (request.getIsNameBased() && targetPartitionKeyRange == null) {
            request.setForceNameCacheRefresh(true);
            this.collection = collectionCache.resolveCollection(request);
            targetPartitionKeyRange = this.tryGetTargetPartitionKeyRange(rangeFromContinuationToken);
        }
        if (targetPartitionKeyRange == null) {
            throw new DocumentClientException(404, "Target range information not found.");
        }
        request.routeTo(new PartitionKeyRangeIdentity(this.collection.getResourceId(), targetPartitionKeyRange.getId()));
        String globalSessionToken = request.getHeaders().get("x-ms-session-token");
        DocumentServiceResponse response = this.executeRequest(request);
        request.getHeaders().put("x-ms-session-token", globalSessionToken);
        if (!PartitionRoutingHelper.tryAddPartitionKeyRangeToContinuationToken(response.getResponseHeaders(), this.providedRanges, routingMapProvider, this.collection.getSelfLink(), targetPartitionKeyRange)) {
            throw new DocumentClientException(404, "Collection not found");
        }
        return response;
    }

    private PartitionKeyRange tryGetTargetPartitionKeyRange(Range<String> rangeFromContinuationToken) throws DocumentClientException {
        PartitionKeyRange targetPartitionKeyRange = PartitionRoutingHelper.tryGetTargetRangeFromContinuationTokenRange(this.providedRanges, this.client.getPartitionKeyRangeCache(), this.collection.getSelfLink(), rangeFromContinuationToken);
        return targetPartitionKeyRange;
    }

    private boolean populateProvidedRanges(DocumentServiceRequest request) throws DocumentClientException {
        if (this.providedRanges != null) {
            return false;
        }
        if (this.providedRanges == null && this.queryExecutionInfo != null) {
            this.providedRanges = this.queryExecutionInfo.getQueryRanges();
            return true;
        }
        String version = request.getHeaders().get("x-ms-version");
        version = version == null || version.isEmpty() ? "2018-09-17" : version;
        String enableCrossPartitionQueryHeader = request.getHeaders().get("x-ms-documentdb-query-enablecrosspartition");
        boolean enableCrossPartitionQuery = Boolean.parseBoolean(enableCrossPartitionQueryHeader);
        this.providedRanges = this.shouldExecuteQuery() ? PartitionRoutingHelper.getProvidedPartitionKeyRanges(this.querySpec, enableCrossPartitionQuery, false, this.collection.getPartitionKey(), this.client.getQueryPartitionProvider(), version) : new ArrayList<Range<String>>(){
            {
                this.add(new Range<String>(PartitionKeyInternalHelper.MinimumInclusiveEffectivePartitionKey, PartitionKeyInternalHelper.MaximumExclusiveEffectivePartitionKey, true, false));
            }
        };
        return true;
    }
}

