/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.PathParser;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfoInternal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceJNIWrapper {
    private static final long E_POINTER = -2147467261L;
    private static final long E_INVALIDARG = -2147024809L;
    private static final long E_UNEXPECTED = -2147418113L;
    private static final long DISP_E_BUFFERTOOSMALL = -2147352557L;
    private static final long E_INVALID_PAYLOAD = -2146825472L;
    private static final long S_OK = 0L;
    private static final long S_FALSE = 1L;
    private static int INITIAL_BUFFER_SIZE = 1024;
    private static final String LIBRARY_NAME = "Microsoft.Azure.Documents.ServiceInterop";
    private static final String[] JNI_RESOURCES = new String[]{"Microsoft.Azure.Documents.ServiceInterop.dll", "DocumentDB.Spatial.Sql.dll"};
    private static final Logger logger = LoggerFactory.getLogger(ServiceJNIWrapper.class);
    private static ServiceJNIWrapper instance = new ServiceJNIWrapper();
    private static boolean isJNILoaded = false;
    private static String systemArchitecture = System.getProperty("os.arch");
    private static String osName = System.getProperty("os.name");

    private native long CreateServiceProvider(String var1, LongWrapper var2);

    private native long ReleaseServiceProvider(long var1);

    private native long GetPartitionKeyRangesFromQuery(long var1, String var3, String[] var4, int[] var5, int var6, int var7, StringBuilder var8, int var9, IntWrapper var10);

    private static void throwIfFailed(long hResult, StringBuilder serializedQueryExecutionInfo) {
        if (hResult == -2147467261L) {
            throw new NullPointerException("Null reference in the JNI wrapper");
        }
        if (hResult == -2147024809L) {
            throw new IllegalArgumentException("Invalid argument in the JNI wrapper");
        }
        if (hResult == -2147418113L) {
            throw new IllegalStateException("Unexpected error in the JNI wrapper");
        }
        if (hResult == -2146825472L) {
            throw new IllegalArgumentException(serializedQueryExecutionInfo.toString());
        }
        if (hResult != 0L && hResult != 1L) {
            throw new IllegalStateException(String.format("Error occurred in the JNI 0x%s", Long.toHexString(hResult)));
        }
    }

    private static ServiceJNIWrapper getInstance() {
        if (!isJNILoaded) {
            throw new UnsupportedOperationException(String.format("Unable to load %s.", LIBRARY_NAME));
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyNativeDllToWorkingDirectory() {
        String workingDir = System.getProperty("user.dir");
        for (String resource : JNI_RESOURCES) {
            Path path = Paths.get(workingDir, resource);
            File file = path.toFile();
            if (!file.exists() || !file.isFile()) {
                InputStream stream = ServiceJNIWrapper.class.getResourceAsStream("/" + resource);
                if (stream != null) {
                    try {
                        Files.copy(stream, path, new CopyOption[0]);
                        logger.info("{} copied to working directory.", (Object)resource);
                        continue;
                    }
                    catch (IOException e) {
                        logger.warn("Unable to copy resource {}.", (Object)resource);
                        continue;
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close {} stream.", (Object)resource);
                        }
                    }
                }
                logger.warn("Unable to load resource {}.", (Object)resource);
                continue;
            }
            logger.info("{} exists in working directory.", (Object)resource);
        }
    }

    private static boolean isSupportedPlatform() {
        return osName != null && osName.toLowerCase().indexOf("win") >= 0 && systemArchitecture != null && systemArchitecture.toLowerCase().indexOf("64") >= 0;
    }

    private static void initializeServiceJni() {
        if (ServiceJNIWrapper.isSupportedPlatform()) {
            try {
                ServiceJNIWrapper.copyNativeDllToWorkingDirectory();
                System.loadLibrary(LIBRARY_NAME);
                isJNILoaded = true;
                logger.info("ServiceJNI has loaded.");
            }
            catch (UnsatisfiedLinkError e) {
                logger.warn("Unable to find {}.", (Object)LIBRARY_NAME);
                isJNILoaded = false;
            }
        } else {
            logger.warn("'{}' with '{}' system is not compatible with native library. JNI not loaded.", (Object)osName, (Object)systemArchitecture);
            isJNILoaded = false;
        }
    }

    public static boolean isServiceJNIAvailable() {
        return isJNILoaded;
    }

    public static long createServiceProvider(String configJsonString) {
        LongWrapper serviceProviderPointer = new LongWrapper();
        long hResult = ServiceJNIWrapper.getInstance().CreateServiceProvider(configJsonString, serviceProviderPointer);
        ServiceJNIWrapper.throwIfFailed(hResult, null);
        return serviceProviderPointer.getValue();
    }

    public static void releaseServiceProvider(long serviceProviderPointer) {
        long hResult = ServiceJNIWrapper.getInstance().ReleaseServiceProvider(serviceProviderPointer);
        ServiceJNIWrapper.throwIfFailed(hResult, null);
    }

    private static String getSerializedPartitionKeyRangesFromQuery(long serviceProviderPointer, SqlQuerySpec querySpec, PartitionKeyDefinition partitionKeyDefinition) {
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths() == null) {
            throw new IllegalArgumentException("partitionKeyDefinition");
        }
        StringBuilder serializedQueryExecutionInfoBuffer = new StringBuilder();
        ArrayList<String> tokensList = new ArrayList<String>();
        int[] tokenLengths = new int[partitionKeyDefinition.getPaths().size()];
        int index = 0;
        for (String path : partitionKeyDefinition.getPaths()) {
            Collection<String> parts = PathParser.getPathParts(path);
            tokensList.addAll(parts);
            tokenLengths[index++] = parts.size();
        }
        String queryText = querySpec.toJson();
        serializedQueryExecutionInfoBuffer.setLength(0);
        serializedQueryExecutionInfoBuffer.ensureCapacity(INITIAL_BUFFER_SIZE);
        IntWrapper serializedPartitionedQueryExecutionInfoResultLength = new IntWrapper();
        int partitionKind = partitionKeyDefinition.getKind().ordinal();
        long hResult = ServiceJNIWrapper.getInstance().GetPartitionKeyRangesFromQuery(serviceProviderPointer, queryText, tokensList.toArray(new String[0]), tokenLengths, partitionKeyDefinition.getPaths().size(), partitionKind, serializedQueryExecutionInfoBuffer, serializedQueryExecutionInfoBuffer.capacity(), serializedPartitionedQueryExecutionInfoResultLength);
        if (hResult == -2147352557L) {
            serializedQueryExecutionInfoBuffer.setLength(0);
            serializedQueryExecutionInfoBuffer.ensureCapacity(serializedPartitionedQueryExecutionInfoResultLength.getValue());
            hResult = ServiceJNIWrapper.getInstance().GetPartitionKeyRangesFromQuery(serviceProviderPointer, queryText, tokensList.toArray(new String[0]), tokenLengths, partitionKeyDefinition.getPaths().size(), partitionKind, serializedQueryExecutionInfoBuffer, serializedQueryExecutionInfoBuffer.capacity(), serializedPartitionedQueryExecutionInfoResultLength);
        }
        ServiceJNIWrapper.throwIfFailed(hResult, serializedQueryExecutionInfoBuffer);
        return serializedQueryExecutionInfoBuffer.toString();
    }

    public static PartitionedQueryExecutionInfoInternal getPartitionKeyRangesFromQuery(long serviceProviderPointer, SqlQuerySpec querySpec, PartitionKeyDefinition partitionKeyDefinition) {
        String serializedPartitionKeyRangesFromQuery = ServiceJNIWrapper.getSerializedPartitionKeyRangesFromQuery(serviceProviderPointer, querySpec, partitionKeyDefinition);
        PartitionedQueryExecutionInfoInternal partitionedQueryExecutionInfoInternal = null;
        try {
            partitionedQueryExecutionInfoInternal = (PartitionedQueryExecutionInfoInternal)Utils.getSimpleObjectMapper().readValue(serializedPartitionKeyRangesFromQuery, PartitionedQueryExecutionInfoInternal.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to deserialize partition query execution information: '%s'", serializedPartitionKeyRangesFromQuery));
        }
        return partitionedQueryExecutionInfoInternal;
    }

    static {
        ServiceJNIWrapper.initializeServiceJni();
    }

    private static class IntWrapper {
        private int value;

        private IntWrapper() {
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    private static class LongWrapper {
        private long value;

        private LongWrapper() {
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }
    }
}

