/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConsistentHashRing;
import com.microsoft.azure.documentdb.HashGenerator;
import com.microsoft.azure.documentdb.MurmurHash;
import com.microsoft.azure.documentdb.PartitionKeyExtractor;
import com.microsoft.azure.documentdb.PartitionResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
public class HashPartitionResolver
implements PartitionResolver {
    private static final int defaultNumberOfVirtualNodesPerCollection = 128;
    private ConsistentHashRing consistentHashRing;
    private ArrayList<String> collectionLinks = new ArrayList();
    private PartitionKeyExtractor partitionKeyExtractor;

    public HashPartitionResolver(PartitionKeyExtractor partitionKeyExtractor, Iterable<String> collectionLinks) {
        this(partitionKeyExtractor, collectionLinks, 128, null);
    }

    public HashPartitionResolver(PartitionKeyExtractor partitionKeyExtractor, Iterable<String> collectionLinks, int numberOfVirtualNodesPerCollection) {
        this(partitionKeyExtractor, collectionLinks, numberOfVirtualNodesPerCollection, null);
    }

    public HashPartitionResolver(PartitionKeyExtractor partitionKeyExtractor, Iterable<String> collectionLinks, HashGenerator hashGenerator) {
        this(partitionKeyExtractor, collectionLinks, 128, hashGenerator);
    }

    public HashPartitionResolver(PartitionKeyExtractor partitionKeyExtractor, Iterable<String> collectionLinks, int numberOfVirtualNodesPerCollection, HashGenerator hashGenerator) {
        if (partitionKeyExtractor == null) {
            throw new IllegalArgumentException("partitionKeyExtractor");
        }
        if (collectionLinks == null) {
            throw new IllegalArgumentException("collectionLinks");
        }
        if (numberOfVirtualNodesPerCollection <= 0) {
            throw new IllegalArgumentException("The number of virtual nodes per collection must greater than 0.");
        }
        this.partitionKeyExtractor = partitionKeyExtractor;
        for (String collectionLink : collectionLinks) {
            this.collectionLinks.add(collectionLink);
        }
        if (hashGenerator == null) {
            hashGenerator = new MurmurHash();
        }
        this.consistentHashRing = new ConsistentHashRing(this.collectionLinks, numberOfVirtualNodesPerCollection, hashGenerator);
    }

    @Override
    public String resolveForCreate(Object document) {
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Object partitionKey = this.partitionKeyExtractor.getPartitionKey(document);
        return this.consistentHashRing.getCollectionNode(partitionKey);
    }

    @Override
    public Iterable<String> resolveForRead(Object partitionKey) {
        if (partitionKey == null) {
            return this.collectionLinks;
        }
        ArrayList<String> collectionLinks = new ArrayList<String>();
        collectionLinks.add(this.consistentHashRing.getCollectionNode(partitionKey));
        return collectionLinks;
    }

    private List<Map.Entry<String, Long>> getSerializedPartitionList() {
        return this.consistentHashRing.getSerializedPartitionList();
    }
}

