package com.microsoft.azure.documentdb;

/**
 * Specifies the conflict resolution modes supported by Azure Cosmos DB, as
 * specified in {@link ConflictResolutionPolicy}
 */
public enum ConflictResolutionMode {
    /**
     * Last writer wins conflict resolution mode
     * <p>
     * Setting the ConflictResolutionMode to "LastWriterWins" indicates that
     * conflict resolution should be done by inspecting a field in the conflicting
     * documents and picking the document which has the higher value in that path.
     *
     * See {@link ConflictResolutionPolicy#createLastWriterWinsPolicy} for details
     * on how to specify the path to be checked for conflict resolution.
     */
    LastWriterWins,

    /**
     * Custom conflict resolution mode
     * <p>
     * Setting the ConflictResolutionMode to "Custom" indicates that conflict
     * resolution is custom handled by a user. The user could elect to register a
     * user specified {@link StoredProcedure} for handling conflicting resources.
     * Should the user not register a user specified StoredProcedure, conflicts will
     * default to being made available as {@link Conflict} resources, which the user
     * can inspect and manually resolve.
     * 
     * See {@link ConflictResolutionPolicy#createCustomPolicy} for
     * details on how to specify the stored procedure to run for conflict
     * resolution.
     */
    Custom,
    
    /**
     * Invalid or unknown mode.
     */
    Invalid
}
