package com.microsoft.azure.documentdb;

import java.util.concurrent.ExecutorService;

import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.query.QueryPartitionProvider;
import com.microsoft.azure.documentdb.internal.routing.CollectionCache;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProvider;

/**
 * Provides methods to do query in the Azure Cosmos DB database service.
 */
public final class DocumentQueryClientInternal    {
        private final DocumentClient innerClient;
        private volatile QueryPartitionProvider queryPartitionProvider;

    public DocumentQueryClientInternal(DocumentClient innerClient) {
        this.innerClient = innerClient;
    }

    public QueryCompatibilityMode getQueryCompatiblityMode() {
        return this.innerClient.getQueryCompatiblityMode();
    }

    public RoutingMapProvider getPartitionKeyRangeCache() {
        return this.innerClient.getPartitionKeyRangeCache();
    }

    public FeedResponse<PartitionKeyRange> readPartitionKeyRangesChangeFeed(String collectionLink, ChangeFeedOptions options) {
        return this.innerClient.queryChangeFeed(collectionLink, ResourceType.PartitionKeyRange,
                PartitionKeyRange.class,
                options);
    }

    public FeedResponse<PartitionKeyRange> readPartitionKeyRanges(String collectionLink, FeedOptions options) {
        return this.innerClient.readPartitionKeyRanges(collectionLink, options);
    }

    public DocumentServiceResponse doReadFeed(DocumentServiceRequest request) throws DocumentClientException {
        return this.innerClient.doReadFeed(request);
    }

    public DocumentServiceResponse doQuery(DocumentServiceRequest request) throws DocumentClientException {
        return this.innerClient.doQuery(request);
    }

    public CollectionCache getCollectionCache() {
        return this.innerClient.getCollectionCache();
    }

    public ExecutorService getExecutorService() {
        return this.innerClient.getExecutorService();
    }

    public QueryPartitionProvider getQueryPartitionProvider() {
        if (this.queryPartitionProvider == null) {
           synchronized (this) {
               if (this.queryPartitionProvider == null) {
                   this.queryPartitionProvider = new QueryPartitionProvider(innerClient
                           .getDatabaseAccountConfigurationProvider()
                           .getQueryEngineConfiguration());
               }
           }
        }

        return this.queryPartitionProvider;
    }
}
