/*
 * Copyright (c) Microsoft Corporation.  All rights reserved.
 */

package com.microsoft.azure.documentdb.internal;

/**
 * Operation types in the Azure Cosmos DB database service.
 */
public enum OperationType {
    Create,
    Delete,
    ExecuteJavaScript,
    Head,
    HeadFeed,
    Query,
    Read,
    ReadFeed,
    Recreate,
    Replace,
    SqlQuery,
    Update,
    Upsert;

    public boolean isWriteOperation() {
        return this == Create ||
                this == Delete ||
                this == Recreate ||
                this == ExecuteJavaScript ||
                this == Replace ||
                this == Upsert ||
                this == Update;
    }
}