package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DatabaseAccountConfigurationProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.HttpConstants;
import org.apache.commons.lang3.StringUtils;

public class RequestHelper {

    public static ConsistencyLevel getConsistencyLevel(DatabaseAccountConfigurationProvider config, DocumentServiceRequest request) throws DocumentClientException {
        ConsistencyLevel targetConsistency = config.getStoreConsistencyPolicy();
        String requestedConsistencyLevelStr = request.getHeaders().get(HttpConstants.HttpHeaders.CONSISTENCY_LEVEL);
        if (StringUtils.isNotEmpty(requestedConsistencyLevelStr)) {
            targetConsistency = ConsistencyLevel.valueOf(requestedConsistencyLevelStr);
        }
        return targetConsistency;
    }
}
