package com.microsoft.azure.documentdb.internal.query;

import org.json.JSONObject;

import com.microsoft.azure.documentdb.*;

/**
 * Used internally for query in the Azure Cosmos DB database service.
 */
public final class QueryItem extends JsonSerializable {
    private Object item;

    public QueryItem(String jsonString) {
        super(jsonString);
    }

    public QueryItem(JSONObject jsonObject) {
        super(jsonObject);
    }

    public Object getItem() {
        if (this.item == null) {
            Object rawItem = super.get("item");
            this.item = super.has("item") ? rawItem : Undefined.Value();
        }

        return this.item;
    }
}
