package com.microsoft.azure.documentdb.internal.routing;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.ImmutablePair;

import com.microsoft.azure.documentdb.PartitionKeyRange;

/**
 * Used internally in request routing in the Azure Cosmos DB database service.
 */
public interface CollectionRoutingMap<TPartitionInfo> {
    List<PartitionKeyRange> getOrderedPartitionKeyRanges();

    PartitionKeyRange getRangeByEffectivePartitionKey(String effectivePartitionKeyValue);

    PartitionKeyRange getRangeByPartitionKeyRangeId(String partitionKeyRangeId);

    Collection<PartitionKeyRange> getOverlappingRanges(Range<String> range);

    Collection<PartitionKeyRange> getOverlappingRanges(Collection<Range<String>> providedPartitionKeyRanges);

    String getChangeFeedNextIfNoneMatch();

    void setChangeFeedNextIfNoneMatch(String changeFeedNextIfNoneMatch);

    CollectionRoutingMap combine(List<ImmutablePair<PartitionKeyRange, TPartitionInfo>> ranges,
                                 String changeFeedNextIfNoneMatch);
}
