/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.ConnectionMode;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import com.microsoft.azure.documentdb.internal.Strings;
import com.microsoft.azure.documentdb.internal.routing.ClientCollectionCache;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameCollectionAwareClientRetryPolicy
implements RetryPolicy {
    private ClientCollectionCache clientCollectionCache;
    private DocumentServiceRequest currentRequest;
    private ConnectionMode connectionMode;
    private EndpointManager globalEndpointManager;
    private static final int retryIntervalInMS = 0;
    private boolean isTriggered;
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameCollectionAwareClientRetryPolicy.class);

    public RenameCollectionAwareClientRetryPolicy(ClientCollectionCache clientCollectionCache, ConnectionMode connectionMode, EndpointManager globalEndpointManager, DocumentServiceRequest currentRequest) {
        this.clientCollectionCache = clientCollectionCache;
        this.currentRequest = currentRequest;
        this.connectionMode = connectionMode;
        this.globalEndpointManager = globalEndpointManager;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) throws DocumentClientException {
        if (this.currentRequest.shouldClearSessionTokenOnSessionReadFailure() && !this.isTriggered && this.currentRequest.getIsNameBased()) {
            this.isTriggered = true;
            URI locationEndpoint = this.globalEndpointManager.resolveServiceEndpoint(this.currentRequest);
            this.currentRequest.routeToLocation(locationEndpoint);
            if (this.connectionMode == ConnectionMode.DirectHttps) {
                this.resetSessionTokenOnRequest();
                return true;
            }
            String oldCollectionRid = this.currentRequest.getResolvedCollectionRid();
            this.currentRequest.setForceNameCacheRefresh(true);
            this.currentRequest.setResolvedCollectionRid(null);
            try {
                DocumentCollection collectionInfo = this.clientCollectionCache.resolveCollection(this.currentRequest);
                if (collectionInfo == null) {
                    LOGGER.debug(String.format("Can't recover from session unavailable exception because resolving collection name %s returned null", this.currentRequest.getResourceAddress()));
                } else if (!Strings.isNullOrEmpty(oldCollectionRid) && !Strings.isNullOrEmpty(collectionInfo.getResourceId())) {
                    this.resetSessionTokenOnRequest();
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.debug(String.format("Can't recover from session unavailable exception because resolving collection name %s failed with %s", this.currentRequest.getResourceAddress(), e.getMessage()));
                throw e;
            }
        }
        return false;
    }

    private void resetSessionTokenOnRequest() {
        this.currentRequest.setSessionToken(null);
        this.currentRequest.getHeaders().remove("x-ms-session-token");
        this.currentRequest.setShouldClearSessionTokenOnSessionReadFailure(false);
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        return 0L;
    }
}

