/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.PartitionKeyExtractor;
import com.microsoft.azure.documentdb.PartitionResolver;
import com.microsoft.azure.documentdb.Range;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Deprecated
public class RangePartitionResolver<T extends Comparable<T>>
implements PartitionResolver {
    private PartitionKeyExtractor partitionKeyExtractor;
    private Map<Range<T>, String> partitionMap;

    public RangePartitionResolver(PartitionKeyExtractor partitionKeyExtractor, Map<Range<T>, String> partitionMap) {
        if (partitionKeyExtractor == null) {
            throw new IllegalArgumentException("partitionKeyExtractor");
        }
        if (partitionMap == null) {
            throw new IllegalArgumentException("partitionMap");
        }
        this.partitionKeyExtractor = partitionKeyExtractor;
        this.partitionMap = partitionMap;
    }

    @Override
    public String resolveForCreate(Object document) {
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Object partitionKey = this.partitionKeyExtractor.getPartitionKey(document);
        Range<T> containingRange = this.getContainingRange(partitionKey);
        if (containingRange == null) {
            throw new UnsupportedOperationException(String.format("A containing range for %s doesn't exist in the partition map.", partitionKey));
        }
        return this.partitionMap.get(containingRange);
    }

    @Override
    public Iterable<String> resolveForRead(Object partitionKey) {
        Set<Range<T>> intersectingRanges = this.getIntersectingRanges(partitionKey);
        ArrayList<String> collectionsLinks = new ArrayList<String>();
        for (Range<T> range : intersectingRanges) {
            collectionsLinks.add(this.partitionMap.get(range));
        }
        return collectionsLinks;
    }

    private Range<T> getContainingRange(Object partitionKey) {
        try {
            Comparable TPartitionKey = (Comparable)partitionKey;
            for (Range<Comparable> range : this.partitionMap.keySet()) {
                if (!range.contains(TPartitionKey)) continue;
                return range;
            }
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException(String.format("Unsupported type %s for partitionKey.", partitionKey.getClass()), ex.getCause());
        }
        return null;
    }

    private Set<Range<T>> getIntersectingRanges(Object partitionKey) {
        HashSet<Range<T>> intersectingRanges = new HashSet<Range<T>>();
        HashSet<Range<Object>> partitionKeyRanges = new HashSet<Range<Object>>();
        if (partitionKey == null) {
            return this.partitionMap.keySet();
        }
        try {
            if (partitionKey instanceof Range) {
                Range RangeTPartitionKey = (Range)partitionKey;
                partitionKeyRanges.add(RangeTPartitionKey);
            } else if (partitionKey instanceof Iterable) {
                Iterable IterableTPartitionKey = (Iterable)partitionKey;
                for (Comparable TPartitionKey : IterableTPartitionKey) {
                    if (TPartitionKey == null) {
                        return this.partitionMap.keySet();
                    }
                    partitionKeyRanges.add(new Range<Comparable>(TPartitionKey));
                }
            } else if (partitionKey instanceof Comparable) {
                Comparable TPartitionKey = (Comparable)partitionKey;
                partitionKeyRanges.add(new Range<Object>(TPartitionKey));
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported type %s for partitionKey.", partitionKey.getClass()));
            }
            for (Range range : partitionKeyRanges) {
                for (Range<T> range2 : this.partitionMap.keySet()) {
                    if (!range2.intersect(range)) continue;
                    intersectingRanges.add(range2);
                }
            }
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException(String.format("The type parameter of RangePartitionResolver doesn't matches with the type of the partition key passed.", new Object[0]), ex.getCause());
        }
        return intersectingRanges;
    }
}

