/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.routing.ClientCollectionCache;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PartitionKeyMismatchRetryPolicy
implements RetryPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionKeyMismatchRetryPolicy.class);
    private final int maxRetryCount = 1;
    private final int retryIntervalInMS = 0;
    private final ClientCollectionCache clientCollectionCache;
    private final String resourcePath;
    private volatile int currentAttempt = 0;

    public PartitionKeyMismatchRetryPolicy(String resourcePath, ClientCollectionCache clientCollectionCache) {
        this.resourcePath = resourcePath;
        this.clientCollectionCache = clientCollectionCache;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        Objects.requireNonNull(this);
        return 0L;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) {
        if (this.currentAttempt >= 1) {
            return false;
        }
        LOGGER.debug("Partition key definition changed. Refresh partition key definition map and retry.");
        String collectionLink = Utils.getCollectionName(this.resourcePath);
        this.clientCollectionCache.refresh(collectionLink);
        ++this.currentAttempt;
        return true;
    }
}

