/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.Error;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.internal.AbstractDocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.PathInfo;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.ResourceId;
import com.microsoft.azure.documentdb.internal.SessionTokenHelper;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.VectorSessionToken;
import com.microsoft.azure.documentdb.internal.directconnectivity.GatewayAddressCache;
import com.microsoft.azure.documentdb.internal.routing.ClientCollectionCache;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionContainer {
    private static final String EMPTY_SESSION_TOKEN = "";
    private static final char SESSION_TOKEN_SEPARATOR = ',';
    private static final char SESSION_TOKEN_PARTITION_SPLITTER = ':';
    private static final Logger logger = LoggerFactory.getLogger(SessionContainer.class);
    private ClientCollectionCache collectionCache;
    private PartitionKeyRangeCache partitionKeyRangeCache;
    private final ConcurrentHashMap<Long, ConcurrentHashMap<String, VectorSessionToken>> collectionResourceIdToSessionTokens;
    private final ConcurrentHashMap<String, Long> collectionNameToCollectionResourceId;
    private final String hostName;

    public SessionContainer(String hostName, ClientCollectionCache collectionCache, PartitionKeyRangeCache partitionKeyRangeCache) {
        this(hostName, collectionCache, partitionKeyRangeCache, new ConcurrentHashMap<String, Long>(), new ConcurrentHashMap<Long, ConcurrentHashMap<String, VectorSessionToken>>());
    }

    public SessionContainer(String hostName, ClientCollectionCache collectionCache, PartitionKeyRangeCache partitionKeyRangeCache, ConcurrentHashMap<String, Long> nameToRidMap, ConcurrentHashMap<Long, ConcurrentHashMap<String, VectorSessionToken>> ridToTokensMap) {
        this.hostName = hostName;
        this.collectionCache = collectionCache;
        this.partitionKeyRangeCache = partitionKeyRangeCache;
        this.collectionResourceIdToSessionTokens = ridToTokensMap;
        this.collectionNameToCollectionResourceId = nameToRidMap;
    }

    public String getHostName() {
        return this.hostName;
    }

    private ConcurrentHashMap<String, VectorSessionToken> getPartitionKeyRangeIdToTokenMap(DocumentServiceRequest request) {
        return this.getPartitionKeyRangeIdToTokenMap(request.getIsNameBased(), request.getResourceId(), request.getResourceAddress());
    }

    private ConcurrentHashMap<String, VectorSessionToken> getPartitionKeyRangeIdToTokenMap(boolean isNameBased, String rId, String resourceAddress) {
        ConcurrentHashMap<String, VectorSessionToken> rangeIdToTokenMap = null;
        if (!isNameBased) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)rId) && (resourceId = ResourceId.parse(rId)).getDocumentCollection() != 0) {
                rangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(resourceId.getUniqueDocumentCollectionId());
            }
        } else {
            String collectionName = Utils.getCollectionName(resourceAddress);
            if (!StringUtils.isEmpty((CharSequence)collectionName) && this.collectionNameToCollectionResourceId.containsKey(collectionName)) {
                rangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(this.collectionNameToCollectionResourceId.get(collectionName));
            }
        }
        return rangeIdToTokenMap;
    }

    public String resolveSessionToken(DocumentServiceRequest request) throws DocumentClientException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        String userSessionToken = request.getHeaders().get("x-ms-session-token");
        PartitionKeyRange partitionKeyRange = null;
        if (request.getResourceType().isPartitioned()) {
            partitionKeyRange = this.resolvePartitionKeyRange(request, false);
        }
        if (!StringUtils.isEmpty((CharSequence)userSessionToken)) {
            return SessionContainer.parseLocalSessionToken(userSessionToken, partitionKeyRange);
        }
        return this.resolveSessionToken(request.getIsNameBased(), request.getResourceId(), request.getResourceAddress(), partitionKeyRange);
    }

    private static String parseLocalSessionToken(String combinedSessionToken, PartitionKeyRange partitionKeyRange) {
        if (combinedSessionToken == null) {
            return null;
        }
        if (partitionKeyRange == null) {
            return combinedSessionToken;
        }
        String[] localSessionTokens = StringUtils.split((String)combinedSessionToken, (char)',');
        HashMap<String, String> partitionToLSN = new HashMap<String, String>();
        for (String localSessionToken : localSessionTokens) {
            String[] parts = StringUtils.split((String)localSessionToken, (char)':');
            if (parts.length != 2) continue;
            partitionToLSN.put(parts[0], parts[1]);
        }
        return SessionContainer.findLocalSessionToken(partitionToLSN, partitionKeyRange);
    }

    private static String findLocalSessionToken(Map<String, ? extends Object> partitionToLSN, PartitionKeyRange partitionKeyRange) {
        if (partitionKeyRange == null) {
            throw new IllegalArgumentException("partitionKeyRange is null");
        }
        if (partitionToLSN.containsKey(partitionKeyRange.getId())) {
            return partitionKeyRange.getId() + ':' + SessionContainer.getSessionTokenString(partitionToLSN.get(partitionKeyRange.getId()));
        }
        Collection<String> parents = partitionKeyRange.getParents();
        ArrayList<String> parentList = new ArrayList<String>(parents);
        for (int i = parentList.size() - 1; i >= 0; --i) {
            String parentId = (String)parentList.get(i);
            if (!partitionToLSN.containsKey(parentId)) continue;
            return parentId + ':' + SessionContainer.getSessionTokenString(partitionToLSN.get(parentId));
        }
        return EMPTY_SESSION_TOKEN;
    }

    private static String getSessionTokenString(Object sessionToken) {
        if (sessionToken instanceof VectorSessionToken) {
            return ((VectorSessionToken)sessionToken).convertToString();
        }
        return (String)sessionToken;
    }

    private PartitionKeyRange resolvePartitionKeyRange(AbstractDocumentServiceRequest request, boolean refreshCache) throws DocumentClientException {
        if (refreshCache) {
            request.setForceAddressRefresh(true);
            request.setForceNameCacheRefresh(true);
        }
        PartitionKeyRange partitionKeyRange = null;
        DocumentCollection collection = this.collectionCache.resolveCollection(request);
        String partitionKeyRangeId = null;
        if (request.getHeaders().get("x-ms-documentdb-partitionkey") != null) {
            partitionKeyRange = GatewayAddressCache.tryResolveServerPartitionByPartitionKey(this.partitionKeyRangeCache, request.getHeaders().get("x-ms-documentdb-partitionkey"), collection, request.isForcePartitionKeyRangeRefresh());
            if (partitionKeyRange != null) {
                partitionKeyRangeId = partitionKeyRange.getId();
            }
        } else if (request.getPartitionKeyRangeIdentity() != null) {
            partitionKeyRangeId = request.getPartitionKeyRangeIdentity().getPartitionKeyRangeId();
            partitionKeyRange = this.partitionKeyRangeCache.getPartitionKeyRangeById(collection.getSelfLink(), partitionKeyRangeId, request.isForcePartitionKeyRangeRefresh());
        }
        if (partitionKeyRangeId == null) {
            return null;
        }
        logger.debug("request.isForcePartitionKeyRangeRefresh={}, partitionKeyRange={}", (Object)request.isForcePartitionKeyRangeRefresh(), (Object)partitionKeyRange);
        if (partitionKeyRange == null) {
            if (refreshCache) {
                HashMap<String, String> responseHeaders = new HashMap<String, String>();
                responseHeaders.put("x-ms-substatus", String.valueOf(1002));
                logger.error("Invalid Partition Key Range");
                throw new DocumentClientException(410, new Error("{ 'message': 'Invalid partition key range' }"), responseHeaders);
            }
            return this.resolvePartitionKeyRange(request, true);
        }
        request.setResolvedPartitionKeyRange(partitionKeyRange);
        return partitionKeyRange;
    }

    private String resolveSessionToken(boolean isNameBased, String rId, String resourceAddress, PartitionKeyRange partitionKeyRange) {
        ConcurrentHashMap<String, VectorSessionToken> rangeIdToTokenMap = this.getPartitionKeyRangeIdToTokenMap(isNameBased, rId, resourceAddress);
        if (rangeIdToTokenMap == null) {
            return EMPTY_SESSION_TOKEN;
        }
        if (partitionKeyRange == null) {
            return this.getCombinedSessionToken(rangeIdToTokenMap);
        }
        VectorSessionToken token = rangeIdToTokenMap.get(partitionKeyRange.getId());
        if (token != null) {
            return partitionKeyRange.getId() + ':' + token.convertToString();
        }
        Collection<String> parentPartitions = partitionKeyRange.getParents();
        if (parentPartitions == null || parentPartitions.isEmpty()) {
            return EMPTY_SESSION_TOKEN;
        }
        return SessionContainer.findLocalSessionToken(rangeIdToTokenMap, partitionKeyRange);
    }

    public String resolveGlobalSessionToken(String collectionLink) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink cannot be null");
        }
        PathInfo pathInfo = PathsHelper.parsePathSegments(collectionLink);
        if (pathInfo == null) {
            return EMPTY_SESSION_TOKEN;
        }
        return this.resolveSessionToken(pathInfo.isNameBased, pathInfo.resourceIdOrFullName, pathInfo.resourcePath, null);
    }

    public void clearToken(DocumentServiceRequest request) {
        Long collectionResourceId = null;
        if (!request.getIsNameBased()) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)request.getResourceId()) && (resourceId = ResourceId.parse(request.getResourceId())).getDocumentCollection() != 0) {
                collectionResourceId = resourceId.getUniqueDocumentCollectionId();
            }
        } else {
            String collectionName = Utils.getCollectionName(request.getResourceAddress());
            if (!StringUtils.isEmpty((CharSequence)collectionName)) {
                collectionResourceId = this.collectionNameToCollectionResourceId.get(collectionName);
                this.collectionNameToCollectionResourceId.remove(collectionName);
            }
        }
        if (collectionResourceId != null) {
            this.collectionResourceIdToSessionTokens.remove(collectionResourceId);
        }
    }

    public void setSessionToken(AbstractDocumentServiceRequest request, Map<String, String> responseHeaders) throws DocumentClientException {
        if (responseHeaders != null && !request.isReadingFromMaster()) {
            ResourceId resourceId;
            String ownerId;
            String ownerFullName;
            String sessionToken = responseHeaders.get("x-ms-session-token");
            if (!StringUtils.isEmpty((CharSequence)sessionToken) && request.getResourceType().isPartitioned()) {
                DocumentCollection collection;
                PartitionKeyRange partitionKeyRangeCache;
                String requestSessionToken = request.getHeaders().get("x-ms-session-token");
                String[] requestTokenParts = requestSessionToken == null ? null : StringUtils.split((String)requestSessionToken, (char)':');
                String[] responseTokenParts = StringUtils.split((String)sessionToken, (char)':');
                if (responseTokenParts.length == 2 && (StringUtils.isEmpty((CharSequence)requestSessionToken) || !StringUtils.equals((CharSequence)requestTokenParts[0], (CharSequence)responseTokenParts[0])) && (partitionKeyRangeCache = this.partitionKeyRangeCache.getPartitionKeyRangeById((collection = this.collectionCache.resolveCollection(request)).getSelfLink(), responseTokenParts[0], false)) == null) {
                    this.partitionKeyRangeCache.getPartitionKeyRangeById(collection.getSelfLink(), responseTokenParts[0], true);
                }
            }
            if (StringUtils.isEmpty((CharSequence)(ownerFullName = responseHeaders.get("x-ms-alt-content-path")))) {
                ownerFullName = request.getResourceAddress();
            }
            String collectionName = Utils.getCollectionName(ownerFullName);
            if (!request.getIsNameBased()) {
                ownerId = request.getResourceId();
            } else {
                ownerId = responseHeaders.get("x-ms-content-path");
                if (StringUtils.isEmpty((CharSequence)ownerId)) {
                    ownerId = request.getResourceId();
                }
            }
            if (!StringUtils.isEmpty((CharSequence)ownerId) && (resourceId = ResourceId.parse(ownerId)).getDocumentCollection() != 0 && !StringUtils.isEmpty((CharSequence)collectionName)) {
                Long uniqueDocumentCollectionId = resourceId.getUniqueDocumentCollectionId();
                this.setSessionToken(uniqueDocumentCollectionId, collectionName, sessionToken);
            }
        }
    }

    private void setSessionToken(long collectionRid, String collectionName, String sessionToken) throws DocumentClientException {
        logger.trace("Set session token: collectionRid = {}, collectionName = {}, sessionToken = {}", new Object[]{collectionRid, collectionName, sessionToken});
        this.collectionResourceIdToSessionTokens.putIfAbsent(collectionRid, new ConcurrentHashMap());
        this.compareAndSetToken(sessionToken, this.collectionResourceIdToSessionTokens.get(collectionRid));
        this.collectionNameToCollectionResourceId.putIfAbsent(collectionName, collectionRid);
    }

    private String getCombinedSessionToken(ConcurrentHashMap<String, VectorSessionToken> tokens) {
        StringBuilder result = new StringBuilder();
        if (tokens != null) {
            Iterator<Map.Entry<String, VectorSessionToken>> iterator = tokens.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, VectorSessionToken> entry = iterator.next();
                result = result.append(entry.getKey()).append(':').append(entry.getValue().convertToString());
                if (!iterator.hasNext()) continue;
                result = result.append(',');
            }
        }
        return result.toString();
    }

    private void compareAndSetToken(String newToken, ConcurrentHashMap<String, VectorSessionToken> oldTokens) throws DocumentClientException {
        String[] newTokenParts;
        if (StringUtils.isNotEmpty((CharSequence)newToken) && (newTokenParts = StringUtils.split((String)newToken, (char)':')).length == 2) {
            boolean success;
            String range = newTokenParts[0];
            VectorSessionToken newSessionToken = SessionTokenHelper.parse(newTokenParts[1]);
            do {
                VectorSessionToken oldSessionToken;
                boolean bl = success = (oldSessionToken = oldTokens.putIfAbsent(range, newSessionToken)) == null;
                if (success) continue;
                success = oldTokens.replace(range, oldSessionToken, oldSessionToken.merge(newSessionToken));
            } while (!success);
        }
    }

    VectorSessionToken resolvePartitionLocalSessionToken(DocumentServiceRequest request, String partitionKeyRangeId) {
        return SessionTokenHelper.resolvePartitionLocalSessionToken(request, partitionKeyRangeId, this.getPartitionKeyRangeIdToTokenMap(request));
    }
}

