/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.query.OrderByQueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.PeekingParallelDocumentQueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.QueryInfo;
import com.microsoft.azure.documentdb.internal.query.executioncomponent.AggregateQueryExecutionComponent;
import com.microsoft.azure.documentdb.internal.query.executioncomponent.DefaultQueryExecutionComponent;
import com.microsoft.azure.documentdb.internal.query.executioncomponent.OrderByQueryExecutionComponent;
import com.microsoft.azure.documentdb.internal.query.executioncomponent.QueryExecutionComponent;
import com.microsoft.azure.documentdb.internal.query.executioncomponent.TopQueryExecutionComponent;
import com.microsoft.azure.documentdb.internal.query.orderbyquery.OrderByQueryResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class PipelinedQueryExecutionContext
implements QueryExecutionContext<Document> {
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private final int actualPageSize;
    protected final QueryExecutionComponent queryExecutionComponent;

    public PipelinedQueryExecutionContext(DocumentQueryClientInternal client, String collectionSelfLink, SqlQuerySpec querySpec, FeedOptions options, String resourceLink, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo) {
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        Integer optionsPageSize = options.getPageSize();
        this.actualPageSize = optionsPageSize != null && optionsPageSize > 0 ? optionsPageSize : 1000;
        QueryExecutionContext<OrderByQueryResult> queryExecutionContext = queryInfo.hasOrderBy() ? OrderByQueryExecutionContext.create(client, collectionSelfLink, querySpec, options, resourceLink, partitionedQueryExecutionInfo) : PeekingParallelDocumentQueryExecutionContext.create(client, collectionSelfLink, querySpec, options, resourceLink, partitionedQueryExecutionInfo, this.actualPageSize);
        QueryExecutionComponent currentQueryExecutionComponent = new DefaultQueryExecutionComponent(queryExecutionContext);
        if (queryInfo.hasAggregates()) {
            currentQueryExecutionComponent = new AggregateQueryExecutionComponent(currentQueryExecutionComponent, queryInfo.getAggregates());
        }
        if (queryInfo.hasTop()) {
            currentQueryExecutionComponent = new TopQueryExecutionComponent(currentQueryExecutionComponent, queryInfo.getTop());
        }
        if (queryInfo.hasOrderBy()) {
            currentQueryExecutionComponent = new OrderByQueryExecutionComponent((QueryExecutionContext)currentQueryExecutionComponent);
        }
        this.queryExecutionComponent = currentQueryExecutionComponent;
    }

    @Override
    public List<Document> fetchNextBlock() throws DocumentClientException {
        ArrayList<Document> result = null;
        while ((result == null || result.size() < this.actualPageSize) && this.hasNext()) {
            Document document;
            if (result == null) {
                result = new ArrayList<Document>(this.actualPageSize);
            }
            if ((document = this.next()) == null) continue;
            result.add(document);
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.queryExecutionComponent.hasNext();
    }

    @Override
    public Document next() {
        return this.queryExecutionComponent.next();
    }

    @Override
    public void remove() {
        this.queryExecutionComponent.remove();
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return this.queryExecutionComponent.getResponseHeaders();
    }

    @Override
    public void onNotifyStop() {
        this.queryExecutionComponent.onNotifyStop();
    }
}

