/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.routing;

import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.internal.routing.CollectionRoutingMap;
import com.microsoft.azure.documentdb.internal.routing.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCollectionRoutingMap<TPartitionInfo>
implements CollectionRoutingMap<TPartitionInfo> {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryCollectionRoutingMap.class);
    private final Map<String, ImmutablePair<PartitionKeyRange, TPartitionInfo>> rangeById;
    private final Map<TPartitionInfo, PartitionKeyRange> rangeByInfo;
    private final List<PartitionKeyRange> orderedPartitionKeyRanges;
    private final List<Range<String>> orderedRanges;
    private final List<TPartitionInfo> orderedPartitionInfo;
    private String collectionUniqueId;
    private HashSet<String> goneRangeIds;
    private String changeFeedNextIfNoneMatch;

    private InMemoryCollectionRoutingMap(Map<String, ImmutablePair<PartitionKeyRange, TPartitionInfo>> rangeById, Map<TPartitionInfo, PartitionKeyRange> rangeByInfo, List<PartitionKeyRange> orderedPartitionKeyRanges, List<TPartitionInfo> orderedPartitionInfo, String collectionUniqueId) {
        this.rangeById = rangeById;
        this.rangeByInfo = rangeByInfo;
        this.orderedPartitionKeyRanges = orderedPartitionKeyRanges;
        this.orderedRanges = new ArrayList<Range<String>>(this.orderedPartitionKeyRanges.size());
        for (PartitionKeyRange range : this.orderedPartitionKeyRanges) {
            this.orderedRanges.add(range.toRange());
        }
        this.orderedPartitionInfo = orderedPartitionInfo;
        this.collectionUniqueId = collectionUniqueId;
        this.goneRangeIds = new HashSet();
        for (PartitionKeyRange r : orderedPartitionKeyRanges) {
            if (r.getParents() == null) continue;
            this.goneRangeIds.addAll(r.getParents());
        }
    }

    private static <TPartitionInfo> InMemoryCollectionRoutingMap<TPartitionInfo> tryCreateRoutingMap(Iterable<ImmutablePair<PartitionKeyRange, TPartitionInfo>> ranges, String collectionUniqueId) {
        HashMap<String, ImmutablePair<PartitionKeyRange, TPartitionInfo>> rangeById = new HashMap<String, ImmutablePair<PartitionKeyRange, TPartitionInfo>>();
        HashMap<Object, Object> rangeByInfo = new HashMap<Object, Object>();
        ArrayList<ImmutablePair<PartitionKeyRange, TPartitionInfo>> sortedRanges = new ArrayList<ImmutablePair<PartitionKeyRange, TPartitionInfo>>();
        for (ImmutablePair<PartitionKeyRange, TPartitionInfo> pair : ranges) {
            rangeById.put(((PartitionKeyRange)pair.left).getId(), pair);
            rangeByInfo.put(pair.right, pair.left);
            sortedRanges.add(pair);
        }
        Collections.sort(sortedRanges, new MinPartitionKeyPairComparator());
        ArrayList<PartitionKeyRange> orderedPartitionKeyRanges = new ArrayList<PartitionKeyRange>(sortedRanges.size());
        ArrayList<Object> orderedPartitionInfo = new ArrayList<Object>(sortedRanges.size());
        for (ImmutablePair immutablePair : sortedRanges) {
            orderedPartitionKeyRanges.add((PartitionKeyRange)immutablePair.left);
            orderedPartitionInfo.add(immutablePair.right);
        }
        return new InMemoryCollectionRoutingMap<TPartitionInfo>(rangeById, rangeByInfo, orderedPartitionKeyRanges, orderedPartitionInfo, collectionUniqueId);
    }

    @Override
    public CollectionRoutingMap combine(List<ImmutablePair<PartitionKeyRange, TPartitionInfo>> ranges, String changeFeedNextIfNoneMatch) {
        for (ImmutablePair<PartitionKeyRange, TPartitionInfo> immutablePair : ranges) {
            if (((PartitionKeyRange)immutablePair.left).getParents() == null) continue;
            this.goneRangeIds.addAll(((PartitionKeyRange)immutablePair.left).getParents());
        }
        for (String string : this.goneRangeIds) {
            this.rangeById.remove(string);
        }
        for (ImmutablePair immutablePair : ranges) {
            if (this.goneRangeIds.contains(((PartitionKeyRange)immutablePair.left).getId())) continue;
            this.rangeById.put(((PartitionKeyRange)immutablePair.left).getId(), immutablePair);
        }
        InMemoryCollectionRoutingMap<TPartitionInfo> routingMap = InMemoryCollectionRoutingMap.tryCreateRoutingMap(this.rangeById.values(), this.collectionUniqueId);
        logger.debug("Created complete routing map with {} key range", (Object)routingMap.getOrderedPartitionKeyRanges().size());
        if (!InMemoryCollectionRoutingMap.isCompleteSetOfRanges(this.collectionUniqueId, routingMap.getOrderedPartitionKeyRanges())) {
            return null;
        }
        routingMap.setChangeFeedNextIfNoneMatch(changeFeedNextIfNoneMatch);
        return routingMap;
    }

    public static <TPartitionInfo> InMemoryCollectionRoutingMap<TPartitionInfo> tryCreateCompleteRoutingMap(Iterable<ImmutablePair<PartitionKeyRange, TPartitionInfo>> ranges, String collectionUniqueId) {
        if (ranges == null) {
            throw new IllegalArgumentException("The key ranges list cannot be null");
        }
        InMemoryCollectionRoutingMap<TPartitionInfo> routingMap = InMemoryCollectionRoutingMap.tryCreateRoutingMap(ranges, collectionUniqueId);
        logger.debug("Created complete routing map with {} key range", (Object)routingMap.getOrderedPartitionKeyRanges().size());
        if (!InMemoryCollectionRoutingMap.isCompleteSetOfRanges(collectionUniqueId, routingMap.getOrderedPartitionKeyRanges())) {
            return null;
        }
        return routingMap;
    }

    private static boolean isCompleteSetOfRanges(String collectionId, List<PartitionKeyRange> orderedRanges) {
        boolean isComplete = false;
        if (orderedRanges.size() > 0) {
            boolean firstRangeValid;
            PartitionKeyRange firstRange = orderedRanges.get(0);
            PartitionKeyRange lastRange = orderedRanges.get(orderedRanges.size() - 1);
            isComplete = firstRangeValid = firstRange.getMinInclusive().compareTo("") == 0;
            if (!firstRangeValid) {
                logger.warn("First partition key range is invalid. collectionId {}, first range {}", (Object)collectionId, (Object)firstRange.toJson());
            }
            boolean lastRangeValid = lastRange.getMaxExclusive().compareTo("FF") == 0;
            isComplete &= lastRangeValid;
            if (!lastRangeValid) {
                logger.warn("Last partition key range is invalid. collectionId {}, last range {}", (Object)collectionId, (Object)lastRange.toJson());
            }
            for (int i = 1; i < orderedRanges.size(); ++i) {
                PartitionKeyRange previousRange = orderedRanges.get(i - 1);
                PartitionKeyRange currentRange = orderedRanges.get(i);
                boolean gapValid = previousRange.getMaxExclusive().compareTo(currentRange.getMinInclusive()) == 0;
                isComplete &= gapValid;
                if (!gapValid) {
                    logger.warn("Partition key range gap is invalid. collectionId {}, previous range {}, current range {}", new Object[]{collectionId, previousRange.toJson(), currentRange.toJson()});
                }
                if (isComplete) continue;
                if (previousRange.getMaxExclusive().compareTo(currentRange.getMinInclusive()) <= 0) break;
                throw new IllegalStateException(String.format("Ranges overlap %s and %s", previousRange.toJson(), currentRange.toJson()));
            }
        }
        return isComplete;
    }

    public String getCollectionUniqueId() {
        return this.collectionUniqueId;
    }

    public TPartitionInfo getHeadPartition() {
        return this.orderedPartitionInfo.get(0);
    }

    public TPartitionInfo getTailPartition() {
        return this.orderedPartitionInfo.get(this.orderedPartitionInfo.size() - 1);
    }

    public List<TPartitionInfo> getOrderedPartitionInfo() {
        return this.orderedPartitionInfo;
    }

    @Override
    public List<PartitionKeyRange> getOrderedPartitionKeyRanges() {
        return this.orderedPartitionKeyRanges;
    }

    @Override
    public PartitionKeyRange getRangeByEffectivePartitionKey(String effectivePartitionKeyValue) {
        if ("".compareTo(effectivePartitionKeyValue) == 0) {
            return this.orderedPartitionKeyRanges.get(0);
        }
        if ("FF".compareTo(effectivePartitionKeyValue) == 0) {
            return null;
        }
        int index = Collections.binarySearch(this.orderedRanges, Range.getPointRange(effectivePartitionKeyValue), new Range.MinComparator());
        if (index < 0) {
            index = Math.max(0, -index - 2);
        }
        return this.orderedPartitionKeyRanges.get(index);
    }

    @Override
    public PartitionKeyRange getRangeByPartitionKeyRangeId(String partitionKeyRangeId) {
        ImmutablePair<PartitionKeyRange, TPartitionInfo> pair = this.rangeById.get(partitionKeyRangeId);
        return pair == null ? null : (PartitionKeyRange)pair.left;
    }

    public TPartitionInfo getInfoByPartitionKeyRangeId(String partitionKeyRangeId) {
        ImmutablePair<PartitionKeyRange, TPartitionInfo> pair = this.rangeById.get(partitionKeyRangeId);
        return (TPartitionInfo)(pair == null ? null : pair.right);
    }

    public PartitionKeyRange getPartitionKeyRangeByPartitionInfo(TPartitionInfo partitionInfo) {
        return this.rangeByInfo.get(partitionInfo);
    }

    @Override
    public Collection<PartitionKeyRange> getOverlappingRanges(Range<String> range) {
        return this.getOverlappingRanges(Arrays.asList(range));
    }

    @Override
    public Collection<PartitionKeyRange> getOverlappingRanges(Collection<Range<String>> providedPartitionKeyRanges) {
        if (providedPartitionKeyRanges == null) {
            throw new IllegalArgumentException("providedPartitionKeyRanges");
        }
        TreeMap<String, PartitionKeyRange> partitionRanges = new TreeMap<String, PartitionKeyRange>();
        for (Range<String> range : providedPartitionKeyRanges) {
            int maxIndex;
            int minIndex = Collections.binarySearch(this.orderedRanges, range, new Range.MinComparator());
            if (minIndex < 0) {
                minIndex = Math.max(minIndex, -minIndex - 2);
            }
            if ((maxIndex = Collections.binarySearch(this.orderedRanges, range, new Range.MaxComparator())) < 0) {
                maxIndex = Math.min(this.orderedRanges.size() - 1, -maxIndex - 1);
            }
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!Range.checkOverlapping(this.orderedRanges.get(i), range)) continue;
                PartitionKeyRange partitionKeyRange = this.orderedPartitionKeyRanges.get(i);
                partitionRanges.put(partitionKeyRange.getMinInclusive(), partitionKeyRange);
            }
        }
        return partitionRanges.values();
    }

    @Override
    public String getChangeFeedNextIfNoneMatch() {
        return this.changeFeedNextIfNoneMatch;
    }

    @Override
    public void setChangeFeedNextIfNoneMatch(String value) {
        this.changeFeedNextIfNoneMatch = value;
    }

    private static class MinPartitionKeyPairComparator<TPartitionInfo>
    implements Comparator<ImmutablePair<PartitionKeyRange, TPartitionInfo>> {
        private MinPartitionKeyPairComparator() {
        }

        @Override
        public int compare(ImmutablePair<PartitionKeyRange, TPartitionInfo> pair1, ImmutablePair<PartitionKeyRange, TPartitionInfo> pair2) {
            return ((PartitionKeyRange)pair1.left).getMinInclusive().compareTo(((PartitionKeyRange)pair2.left).getMinInclusive());
        }
    }
}

