/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The agent that initiated the event. For most situations, this could be from
 * the authorization context of the request.
 */
public class ContainerRegistryEventActor {
    /**
     * The subject or username associated with the request context that
     * generated the event.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Get the subject or username associated with the request context that generated the event.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the subject or username associated with the request context that generated the event.
     *
     * @param name the name value to set
     * @return the ContainerRegistryEventActor object itself.
     */
    public ContainerRegistryEventActor withName(String name) {
        this.name = name;
        return this;
    }

}
