/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventgrid.customization;

import com.microsoft.azure.eventgrid.models.AppConfigurationKeyValueDeletedEventData;
import com.microsoft.azure.eventgrid.models.AppConfigurationKeyValueModifiedEventData;
import com.microsoft.azure.eventgrid.models.ContainerRegistryChartDeletedEventData;
import com.microsoft.azure.eventgrid.models.ContainerRegistryChartPushedEventData;
import com.microsoft.azure.eventgrid.models.ContainerRegistryImageDeletedEventData;
import com.microsoft.azure.eventgrid.models.ContainerRegistryImagePushedEventData;
import com.microsoft.azure.eventgrid.models.EventHubCaptureFileCreatedEventData;
import com.microsoft.azure.eventgrid.models.IotHubDeviceConnectedEventData;
import com.microsoft.azure.eventgrid.models.IotHubDeviceCreatedEventData;
import com.microsoft.azure.eventgrid.models.IotHubDeviceDeletedEventData;
import com.microsoft.azure.eventgrid.models.IotHubDeviceDisconnectedEventData;
import com.microsoft.azure.eventgrid.models.IotHubDeviceTelemetryEventData;
import com.microsoft.azure.eventgrid.models.MapsGeofenceEnteredEventData;
import com.microsoft.azure.eventgrid.models.MapsGeofenceExitedEventData;
import com.microsoft.azure.eventgrid.models.MapsGeofenceResultEventData;
import com.microsoft.azure.eventgrid.models.MediaJobCanceledEventData;
import com.microsoft.azure.eventgrid.models.MediaJobCancelingEventData;
import com.microsoft.azure.eventgrid.models.MediaJobErroredEventData;
import com.microsoft.azure.eventgrid.models.MediaJobFinishedEventData;
import com.microsoft.azure.eventgrid.models.MediaJobOutputCanceledEventData;
import com.microsoft.azure.eventgrid.models.MediaJobOutputCancelingEventData;
import com.microsoft.azure.eventgrid.models.MediaJobOutputErroredEventData;
import com.microsoft.azure.eventgrid.models.MediaJobOutputFinishedEventData;
import com.microsoft.azure.eventgrid.models.MediaJobOutputProcessingEventData;
import com.microsoft.azure.eventgrid.models.MediaJobOutputProgressEventData;
import com.microsoft.azure.eventgrid.models.MediaJobOutputScheduledEventData;
import com.microsoft.azure.eventgrid.models.MediaJobOutputStateChangeEventData;
import com.microsoft.azure.eventgrid.models.MediaJobProcessingEventData;
import com.microsoft.azure.eventgrid.models.MediaJobScheduledEventData;
import com.microsoft.azure.eventgrid.models.MediaJobStateChangeEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventConnectionRejectedEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventEncoderConnectedEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventEncoderDisconnectedEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventIncomingDataChunkDroppedEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventIncomingStreamReceivedEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventIncomingStreamsOutOfSyncEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventIncomingVideoStreamsOutOfSyncEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventIngestHeartbeatEventData;
import com.microsoft.azure.eventgrid.models.MediaLiveEventTrackDiscontinuityDetectedEventData;
import com.microsoft.azure.eventgrid.models.ResourceActionCancelData;
import com.microsoft.azure.eventgrid.models.ResourceActionFailureData;
import com.microsoft.azure.eventgrid.models.ResourceActionSuccessData;
import com.microsoft.azure.eventgrid.models.ResourceDeleteCancelData;
import com.microsoft.azure.eventgrid.models.ResourceDeleteFailureData;
import com.microsoft.azure.eventgrid.models.ResourceDeleteSuccessData;
import com.microsoft.azure.eventgrid.models.ResourceWriteCancelData;
import com.microsoft.azure.eventgrid.models.ResourceWriteFailureData;
import com.microsoft.azure.eventgrid.models.ResourceWriteSuccessData;
import com.microsoft.azure.eventgrid.models.ServiceBusActiveMessagesAvailableWithNoListenersEventData;
import com.microsoft.azure.eventgrid.models.ServiceBusDeadletterMessagesAvailableWithNoListenersEventData;
import com.microsoft.azure.eventgrid.models.StorageBlobCreatedEventData;
import com.microsoft.azure.eventgrid.models.StorageBlobDeletedEventData;
import com.microsoft.azure.eventgrid.models.SubscriptionDeletedEventData;
import com.microsoft.azure.eventgrid.models.SubscriptionValidationEventData;
import com.microsoft.azure.management.apigeneration.Beta;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

@Beta
final class SystemEventTypeMappings {
    private static Map<String, Type> systemEventMappings = new HashMap<String, Type>();

    SystemEventTypeMappings() {
    }

    @Beta
    public static boolean containsMappingFor(String eventType) {
        if (eventType == null || eventType.isEmpty()) {
            return false;
        }
        return systemEventMappings.containsKey(SystemEventTypeMappings.canonicalizeEventType(eventType));
    }

    @Beta
    public static Type getMapping(String eventType) {
        if (!SystemEventTypeMappings.containsMappingFor(eventType)) {
            return null;
        }
        return systemEventMappings.get(SystemEventTypeMappings.canonicalizeEventType(eventType));
    }

    private static String canonicalizeEventType(String eventType) {
        if (eventType == null) {
            return null;
        }
        return eventType.toLowerCase();
    }

    static {
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.AppConfiguration.KeyValueDeleted"), (Type)((Object)AppConfigurationKeyValueDeletedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.AppConfiguration.KeyValueModified"), (Type)((Object)AppConfigurationKeyValueModifiedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.ContainerRegistry.ImagePushed"), (Type)((Object)ContainerRegistryImagePushedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.ContainerRegistry.ImageDeleted"), (Type)((Object)ContainerRegistryImageDeletedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.ContainerRegistry.ChartDeleted"), (Type)((Object)ContainerRegistryChartDeletedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.ContainerRegistry.ChartPushed"), (Type)((Object)ContainerRegistryChartPushedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Devices.DeviceCreated"), (Type)((Object)IotHubDeviceCreatedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Devices.DeviceDeleted"), (Type)((Object)IotHubDeviceDeletedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Devices.DeviceConnected"), (Type)((Object)IotHubDeviceConnectedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Devices.DeviceDisconnected"), (Type)((Object)IotHubDeviceDisconnectedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Devices.DeviceTelemetry"), (Type)((Object)IotHubDeviceTelemetryEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.EventGrid.SubscriptionValidationEvent"), (Type)((Object)SubscriptionValidationEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.EventGrid.SubscriptionDeletedEvent"), (Type)((Object)SubscriptionDeletedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.EventHub.CaptureFileCreated"), (Type)((Object)EventHubCaptureFileCreatedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Maps.GeofenceEntered"), (Type)((Object)MapsGeofenceEnteredEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Maps.GeofenceExited"), (Type)((Object)MapsGeofenceExitedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Maps.GeofenceResult"), (Type)((Object)MapsGeofenceResultEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobCanceled"), (Type)((Object)MediaJobCanceledEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobCanceling"), (Type)((Object)MediaJobCancelingEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobErrored"), (Type)((Object)MediaJobErroredEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobFinished"), (Type)((Object)MediaJobFinishedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobOutputCanceled"), (Type)((Object)MediaJobOutputCanceledEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobOutputCanceling"), (Type)((Object)MediaJobOutputCancelingEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobOutputErrored"), (Type)((Object)MediaJobOutputErroredEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobOutputFinished"), (Type)((Object)MediaJobOutputFinishedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobOutputProcessing"), (Type)((Object)MediaJobOutputProcessingEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobOutputProgress"), (Type)((Object)MediaJobOutputProgressEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobOutputScheduled"), (Type)((Object)MediaJobOutputScheduledEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobOutputStateChange"), (Type)((Object)MediaJobOutputStateChangeEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobProcessing"), (Type)((Object)MediaJobProcessingEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobScheduled"), (Type)((Object)MediaJobScheduledEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.JobStateChange"), (Type)((Object)MediaJobStateChangeEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventConnectionRejected"), (Type)((Object)MediaLiveEventConnectionRejectedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventEncoderConnected"), (Type)((Object)MediaLiveEventEncoderConnectedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventEncoderDisconnected"), (Type)((Object)MediaLiveEventEncoderDisconnectedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventIncomingDataChunkDropped"), (Type)((Object)MediaLiveEventIncomingDataChunkDroppedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventIncomingStreamsOutOfSync"), (Type)((Object)MediaLiveEventIncomingStreamsOutOfSyncEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventIncomingStreamReceived"), (Type)((Object)MediaLiveEventIncomingStreamReceivedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventIncomingVideoStreamsOutOfSync"), (Type)((Object)MediaLiveEventIncomingVideoStreamsOutOfSyncEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventIngestHeartbeat"), (Type)((Object)MediaLiveEventIngestHeartbeatEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Media.LiveEventTrackDiscontinuityDetected"), (Type)((Object)MediaLiveEventTrackDiscontinuityDetectedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceWriteSuccess"), (Type)((Object)ResourceWriteSuccessData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceWriteFailure"), (Type)((Object)ResourceWriteFailureData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceWriteCancel"), (Type)((Object)ResourceWriteCancelData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceDeleteSuccess"), (Type)((Object)ResourceDeleteSuccessData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceDeleteFailure"), (Type)((Object)ResourceDeleteFailureData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceDeleteCancel"), (Type)((Object)ResourceDeleteCancelData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceActionSuccess"), (Type)((Object)ResourceActionSuccessData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceActionFailure"), (Type)((Object)ResourceActionFailureData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Resources.ResourceActionCancel"), (Type)((Object)ResourceActionCancelData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.ServiceBus.ActiveMessagesAvailableWithNoListeners"), (Type)((Object)ServiceBusActiveMessagesAvailableWithNoListenersEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.ServiceBus.DeadletterMessagesAvailableWithNoListener"), (Type)((Object)ServiceBusDeadletterMessagesAvailableWithNoListenersEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Storage.BlobCreated"), (Type)((Object)StorageBlobCreatedEventData.class));
        systemEventMappings.put(SystemEventTypeMappings.canonicalizeEventType("Microsoft.Storage.BlobDeleted"), (Type)((Object)StorageBlobDeletedEventData.class));
    }
}

