/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventgrid.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.eventgrid.EventGridClient;
import com.microsoft.azure.eventgrid.models.EventGridEvent;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class EventGridClientImpl
extends AzureServiceClient
implements EventGridClient {
    private EventGridClientService service;
    private AzureClient azureClient;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public EventGridClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public EventGridClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public EventGridClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public EventGridClientImpl(ServiceClientCredentials credentials) {
        this("https://{topicHostname}", credentials);
    }

    private EventGridClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public EventGridClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2018-01-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "EventGridClient", "2018-01-01");
    }

    private void initializeService() {
        this.service = (EventGridClientService)this.restClient().retrofit().create(EventGridClientService.class);
    }

    @Override
    public void publishEvents(String topicHostname, List<EventGridEvent> events) {
        ((ServiceResponse)this.publishEventsWithServiceResponseAsync(topicHostname, events).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> publishEventsAsync(String topicHostname, List<EventGridEvent> events, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.publishEventsWithServiceResponseAsync(topicHostname, events), serviceCallback);
    }

    @Override
    public Observable<Void> publishEventsAsync(String topicHostname, List<EventGridEvent> events) {
        return this.publishEventsWithServiceResponseAsync(topicHostname, events).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> publishEventsWithServiceResponseAsync(String topicHostname, List<EventGridEvent> events) {
        if (topicHostname == null) {
            throw new IllegalArgumentException("Parameter topicHostname is required and cannot be null.");
        }
        if (events == null) {
            throw new IllegalArgumentException("Parameter events is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(events);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{topicHostname}", (Object)topicHostname, new Object[0]);
        return this.service.publishEvents(events, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventGridClientImpl.this.publishEventsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> publishEventsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface EventGridClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.eventgrid.EventGridClient publishEvents"})
        @POST(value="api/events")
        public Observable<Response<ResponseBody>> publishEvents(@Body List<EventGridEvent> var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);
    }
}

