/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The content of the event request message.
 */
public class ContainerRegistryArtifactEventData {
    /**
     * The event ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * The time at which the event occurred.
     */
    @JsonProperty(value = "timestamp")
    private DateTime timestamp;

    /**
     * The action that encompasses the provided event.
     */
    @JsonProperty(value = "action")
    private String action;

    /**
     * The target of the event.
     */
    @JsonProperty(value = "target")
    private ContainerRegistryArtifactEventTarget target;

    /**
     * Get the event ID.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the event ID.
     *
     * @param id the id value to set
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the time at which the event occurred.
     *
     * @return the timestamp value
     */
    public DateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the time at which the event occurred.
     *
     * @param timestamp the timestamp value to set
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData withTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the action that encompasses the provided event.
     *
     * @return the action value
     */
    public String action() {
        return this.action;
    }

    /**
     * Set the action that encompasses the provided event.
     *
     * @param action the action value to set
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData withAction(String action) {
        this.action = action;
        return this;
    }

    /**
     * Get the target of the event.
     *
     * @return the target value
     */
    public ContainerRegistryArtifactEventTarget target() {
        return this.target;
    }

    /**
     * Set the target of the event.
     *
     * @param target the target value to set
     * @return the ContainerRegistryArtifactEventData object itself.
     */
    public ContainerRegistryArtifactEventData withTarget(ContainerRegistryArtifactEventTarget target) {
        this.target = target;
        return this;
    }

}
