/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Information about the device connection state event.
 */
public class DeviceConnectionStateEventInfo {
    /**
     * Sequence number is string representation of a hexadecimal number. string
     * compare can be used to identify the larger number because both in ASCII
     * and HEX numbers come after alphabets. If you are converting the string
     * to hex, then the number is a 256 bit number.
     */
    @JsonProperty(value = "sequenceNumber")
    private String sequenceNumber;

    /**
     * Get sequence number is string representation of a hexadecimal number. string compare can be used to identify the larger number because both in ASCII and HEX numbers come after alphabets. If you are converting the string to hex, then the number is a 256 bit number.
     *
     * @return the sequenceNumber value
     */
    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    /**
     * Set sequence number is string representation of a hexadecimal number. string compare can be used to identify the larger number because both in ASCII and HEX numbers come after alphabets. If you are converting the string to hex, then the number is a 256 bit number.
     *
     * @param sequenceNumber the sequenceNumber value to set
     * @return the DeviceConnectionStateEventInfo object itself.
     */
    public DeviceConnectionStateEventInfo withSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

}
