/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The thumbprint is a unique value for the x509 certificate, commonly used to
 * find a particular certificate in a certificate store. The thumbprint is
 * dynamically generated using the SHA1 algorithm, and does not physically
 * exist in the certificate.
 */
public class DeviceTwinInfoX509Thumbprint {
    /**
     * Primary thumbprint for the x509 certificate.
     */
    @JsonProperty(value = "primaryThumbprint")
    private String primaryThumbprint;

    /**
     * Secondary thumbprint for the x509 certificate.
     */
    @JsonProperty(value = "secondaryThumbprint")
    private String secondaryThumbprint;

    /**
     * Get primary thumbprint for the x509 certificate.
     *
     * @return the primaryThumbprint value
     */
    public String primaryThumbprint() {
        return this.primaryThumbprint;
    }

    /**
     * Set primary thumbprint for the x509 certificate.
     *
     * @param primaryThumbprint the primaryThumbprint value to set
     * @return the DeviceTwinInfoX509Thumbprint object itself.
     */
    public DeviceTwinInfoX509Thumbprint withPrimaryThumbprint(String primaryThumbprint) {
        this.primaryThumbprint = primaryThumbprint;
        return this;
    }

    /**
     * Get secondary thumbprint for the x509 certificate.
     *
     * @return the secondaryThumbprint value
     */
    public String secondaryThumbprint() {
        return this.secondaryThumbprint;
    }

    /**
     * Set secondary thumbprint for the x509 certificate.
     *
     * @param secondaryThumbprint the secondaryThumbprint value to set
     * @return the DeviceTwinInfoX509Thumbprint object itself.
     */
    public DeviceTwinInfoX509Thumbprint withSecondaryThumbprint(String secondaryThumbprint) {
        this.secondaryThumbprint = secondaryThumbprint;
        return this;
    }

}
