/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Schema of the Data property of an EventGridEvent for a Geofence event
 * (GeofenceEntered, GeofenceExited, GeofenceResult).
 */
public class MapsGeofenceEventProperties {
    /**
     * Lists of the geometry ID of the geofence which is expired relative to
     * the user time in the request.
     */
    @JsonProperty(value = "expiredGeofenceGeometryId")
    private List<String> expiredGeofenceGeometryId;

    /**
     * Lists the fence geometries that either fully contain the coordinate
     * position or have an overlap with the searchBuffer around the fence.
     */
    @JsonProperty(value = "geometries")
    private List<MapsGeofenceGeometry> geometries;

    /**
     * Lists of the geometry ID of the geofence which is in invalid period
     * relative to the user time in the request.
     */
    @JsonProperty(value = "invalidPeriodGeofenceGeometryId")
    private List<String> invalidPeriodGeofenceGeometryId;

    /**
     * True if at least one event is published to the Azure Maps event
     * subscriber, false if no event is published to the Azure Maps event
     * subscriber.
     */
    @JsonProperty(value = "isEventPublished")
    private Boolean isEventPublished;

    /**
     * Get lists of the geometry ID of the geofence which is expired relative to the user time in the request.
     *
     * @return the expiredGeofenceGeometryId value
     */
    public List<String> expiredGeofenceGeometryId() {
        return this.expiredGeofenceGeometryId;
    }

    /**
     * Set lists of the geometry ID of the geofence which is expired relative to the user time in the request.
     *
     * @param expiredGeofenceGeometryId the expiredGeofenceGeometryId value to set
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties withExpiredGeofenceGeometryId(List<String> expiredGeofenceGeometryId) {
        this.expiredGeofenceGeometryId = expiredGeofenceGeometryId;
        return this;
    }

    /**
     * Get lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence.
     *
     * @return the geometries value
     */
    public List<MapsGeofenceGeometry> geometries() {
        return this.geometries;
    }

    /**
     * Set lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence.
     *
     * @param geometries the geometries value to set
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties withGeometries(List<MapsGeofenceGeometry> geometries) {
        this.geometries = geometries;
        return this;
    }

    /**
     * Get lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request.
     *
     * @return the invalidPeriodGeofenceGeometryId value
     */
    public List<String> invalidPeriodGeofenceGeometryId() {
        return this.invalidPeriodGeofenceGeometryId;
    }

    /**
     * Set lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request.
     *
     * @param invalidPeriodGeofenceGeometryId the invalidPeriodGeofenceGeometryId value to set
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties withInvalidPeriodGeofenceGeometryId(List<String> invalidPeriodGeofenceGeometryId) {
        this.invalidPeriodGeofenceGeometryId = invalidPeriodGeofenceGeometryId;
        return this;
    }

    /**
     * Get true if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber.
     *
     * @return the isEventPublished value
     */
    public Boolean isEventPublished() {
        return this.isEventPublished;
    }

    /**
     * Set true if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber.
     *
     * @param isEventPublished the isEventPublished value to set
     * @return the MapsGeofenceEventProperties object itself.
     */
    public MapsGeofenceEventProperties withIsEventPublished(Boolean isEventPublished) {
        this.isEventPublished = isEventPublished;
        return this;
    }

}
