/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for MediaJobErrorCategory.
 */
public enum MediaJobErrorCategory {
    /** The error is service related. */
    SERVICE("Service"),

    /** The error is download related. */
    DOWNLOAD("Download"),

    /** The error is upload related. */
    UPLOAD("Upload"),

    /** The error is configuration related. */
    CONFIGURATION("Configuration"),

    /** The error is related to data in the input files. */
    CONTENT("Content");

    /** The actual serialized value for a MediaJobErrorCategory instance. */
    private String value;

    MediaJobErrorCategory(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a MediaJobErrorCategory instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed MediaJobErrorCategory object, or null if unable to parse.
     */
    @JsonCreator
    public static MediaJobErrorCategory fromString(String value) {
        MediaJobErrorCategory[] items = MediaJobErrorCategory.values();
        for (MediaJobErrorCategory item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
