/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The event data for a Job output asset.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata.type")
@JsonTypeName("#Microsoft.Media.JobOutputAsset")
public class MediaJobOutputAsset extends MediaJobOutput {
    /**
     * Gets the Job output asset name.
     */
    @JsonProperty(value = "assetName")
    private String assetName;

    /**
     * Get gets the Job output asset name.
     *
     * @return the assetName value
     */
    public String assetName() {
        return this.assetName;
    }

    /**
     * Set gets the Job output asset name.
     *
     * @param assetName the assetName value to set
     * @return the MediaJobOutputAsset object itself.
     */
    public MediaJobOutputAsset withAssetName(String assetName) {
        this.assetName = assetName;
        return this;
    }

}
