/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Job Output Progress Event Data.
 */
public class MediaJobOutputProgressEventData {
    /**
     * Gets the Job output label.
     */
    @JsonProperty(value = "label")
    private String label;

    /**
     * Gets the Job output progress.
     */
    @JsonProperty(value = "progress")
    private Long progress;

    /**
     * Gets the Job correlation data.
     */
    @JsonProperty(value = "jobCorrelationData")
    private Map<String, String> jobCorrelationData;

    /**
     * Get gets the Job output label.
     *
     * @return the label value
     */
    public String label() {
        return this.label;
    }

    /**
     * Set gets the Job output label.
     *
     * @param label the label value to set
     * @return the MediaJobOutputProgressEventData object itself.
     */
    public MediaJobOutputProgressEventData withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get gets the Job output progress.
     *
     * @return the progress value
     */
    public Long progress() {
        return this.progress;
    }

    /**
     * Set gets the Job output progress.
     *
     * @param progress the progress value to set
     * @return the MediaJobOutputProgressEventData object itself.
     */
    public MediaJobOutputProgressEventData withProgress(Long progress) {
        this.progress = progress;
        return this;
    }

    /**
     * Get gets the Job correlation data.
     *
     * @return the jobCorrelationData value
     */
    public Map<String, String> jobCorrelationData() {
        return this.jobCorrelationData;
    }

    /**
     * Set gets the Job correlation data.
     *
     * @param jobCorrelationData the jobCorrelationData value to set
     * @return the MediaJobOutputProgressEventData object itself.
     */
    public MediaJobOutputProgressEventData withJobCorrelationData(Map<String, String> jobCorrelationData) {
        this.jobCorrelationData = jobCorrelationData;
        return this;
    }

}
