/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Schema of the Data property of an EventGridEvent for a
 * Microsoft.Media.JobOutputStateChange event.
 */
public class MediaJobOutputStateChangeEventData {
    /**
     * The previous state of the Job. Possible values include: 'Canceled',
     * 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'.
     */
    @JsonProperty(value = "previousState", access = JsonProperty.Access.WRITE_ONLY)
    private MediaJobState previousState;

    /**
     * Gets the output.
     */
    @JsonProperty(value = "output")
    private MediaJobOutput output;

    /**
     * Gets the Job correlation data.
     */
    @JsonProperty(value = "jobCorrelationData")
    private Map<String, String> jobCorrelationData;

    /**
     * Get the previous state of the Job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'.
     *
     * @return the previousState value
     */
    public MediaJobState previousState() {
        return this.previousState;
    }

    /**
     * Get gets the output.
     *
     * @return the output value
     */
    public MediaJobOutput output() {
        return this.output;
    }

    /**
     * Set gets the output.
     *
     * @param output the output value to set
     * @return the MediaJobOutputStateChangeEventData object itself.
     */
    public MediaJobOutputStateChangeEventData withOutput(MediaJobOutput output) {
        this.output = output;
        return this;
    }

    /**
     * Get gets the Job correlation data.
     *
     * @return the jobCorrelationData value
     */
    public Map<String, String> jobCorrelationData() {
        return this.jobCorrelationData;
    }

    /**
     * Set gets the Job correlation data.
     *
     * @param jobCorrelationData the jobCorrelationData value to set
     * @return the MediaJobOutputStateChangeEventData object itself.
     */
    public MediaJobOutputStateChangeEventData withJobCorrelationData(Map<String, String> jobCorrelationData) {
        this.jobCorrelationData = jobCorrelationData;
        return this;
    }

}
