/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Encoder connect event data.
 */
public class MediaLiveEventIncomingStreamReceivedEventData {
    /**
     * Gets the ingest URL provided by the live event.
     */
    @JsonProperty(value = "ingestUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String ingestUrl;

    /**
     * Gets the type of the track (Audio / Video).
     */
    @JsonProperty(value = "trackType", access = JsonProperty.Access.WRITE_ONLY)
    private String trackType;

    /**
     * Gets the track name.
     */
    @JsonProperty(value = "trackName", access = JsonProperty.Access.WRITE_ONLY)
    private String trackName;

    /**
     * Gets the bitrate of the track.
     */
    @JsonProperty(value = "bitrate", access = JsonProperty.Access.WRITE_ONLY)
    private Long bitrate;

    /**
     * Gets the remote IP.
     */
    @JsonProperty(value = "encoderIp", access = JsonProperty.Access.WRITE_ONLY)
    private String encoderIp;

    /**
     * Gets the remote port.
     */
    @JsonProperty(value = "encoderPort", access = JsonProperty.Access.WRITE_ONLY)
    private String encoderPort;

    /**
     * Gets the first timestamp of the data chunk received.
     */
    @JsonProperty(value = "timestamp", access = JsonProperty.Access.WRITE_ONLY)
    private String timestamp;

    /**
     * Gets the duration of the first data chunk.
     */
    @JsonProperty(value = "duration", access = JsonProperty.Access.WRITE_ONLY)
    private String duration;

    /**
     * Gets the timescale in which timestamp is represented.
     */
    @JsonProperty(value = "timescale", access = JsonProperty.Access.WRITE_ONLY)
    private String timescale;

    /**
     * Get gets the ingest URL provided by the live event.
     *
     * @return the ingestUrl value
     */
    public String ingestUrl() {
        return this.ingestUrl;
    }

    /**
     * Get gets the type of the track (Audio / Video).
     *
     * @return the trackType value
     */
    public String trackType() {
        return this.trackType;
    }

    /**
     * Get gets the track name.
     *
     * @return the trackName value
     */
    public String trackName() {
        return this.trackName;
    }

    /**
     * Get gets the bitrate of the track.
     *
     * @return the bitrate value
     */
    public Long bitrate() {
        return this.bitrate;
    }

    /**
     * Get gets the remote IP.
     *
     * @return the encoderIp value
     */
    public String encoderIp() {
        return this.encoderIp;
    }

    /**
     * Get gets the remote port.
     *
     * @return the encoderPort value
     */
    public String encoderPort() {
        return this.encoderPort;
    }

    /**
     * Get gets the first timestamp of the data chunk received.
     *
     * @return the timestamp value
     */
    public String timestamp() {
        return this.timestamp;
    }

    /**
     * Get gets the duration of the first data chunk.
     *
     * @return the duration value
     */
    public String duration() {
        return this.duration;
    }

    /**
     * Get gets the timescale in which timestamp is represented.
     *
     * @return the timescale value
     */
    public String timescale() {
        return this.timescale;
    }

}
