/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Ingest track discontinuity detected event data.
 */
public class MediaLiveEventTrackDiscontinuityDetectedEventData {
    /**
     * Gets the type of the track (Audio / Video).
     */
    @JsonProperty(value = "trackType", access = JsonProperty.Access.WRITE_ONLY)
    private String trackType;

    /**
     * Gets the track name.
     */
    @JsonProperty(value = "trackName", access = JsonProperty.Access.WRITE_ONLY)
    private String trackName;

    /**
     * Gets the bitrate.
     */
    @JsonProperty(value = "bitrate", access = JsonProperty.Access.WRITE_ONLY)
    private Long bitrate;

    /**
     * Gets the timestamp of the previous fragment.
     */
    @JsonProperty(value = "previousTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private String previousTimestamp;

    /**
     * Gets the timestamp of the current fragment.
     */
    @JsonProperty(value = "newTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private String newTimestamp;

    /**
     * Gets the timescale in which both timestamps and discontinuity gap are
     * represented.
     */
    @JsonProperty(value = "timescale", access = JsonProperty.Access.WRITE_ONLY)
    private String timescale;

    /**
     * Gets the discontinuity gap between PreviousTimestamp and NewTimestamp.
     */
    @JsonProperty(value = "discontinuityGap", access = JsonProperty.Access.WRITE_ONLY)
    private String discontinuityGap;

    /**
     * Get gets the type of the track (Audio / Video).
     *
     * @return the trackType value
     */
    public String trackType() {
        return this.trackType;
    }

    /**
     * Get gets the track name.
     *
     * @return the trackName value
     */
    public String trackName() {
        return this.trackName;
    }

    /**
     * Get gets the bitrate.
     *
     * @return the bitrate value
     */
    public Long bitrate() {
        return this.bitrate;
    }

    /**
     * Get gets the timestamp of the previous fragment.
     *
     * @return the previousTimestamp value
     */
    public String previousTimestamp() {
        return this.previousTimestamp;
    }

    /**
     * Get gets the timestamp of the current fragment.
     *
     * @return the newTimestamp value
     */
    public String newTimestamp() {
        return this.newTimestamp;
    }

    /**
     * Get gets the timescale in which both timestamps and discontinuity gap are represented.
     *
     * @return the timescale value
     */
    public String timescale() {
        return this.timescale;
    }

    /**
     * Get gets the discontinuity gap between PreviousTimestamp and NewTimestamp.
     *
     * @return the discontinuityGap value
     */
    public String discontinuityGap() {
        return this.discontinuityGap;
    }

}
