/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.eventgrid.models;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Schema of the Data property of an EventGridEvent for a
 * Microsoft.EventGrid.SubscriptionValidationEvent.
 */
public class SubscriptionValidationEventData {
    /**
     * The validation code sent by Azure Event Grid to validate an event
     * subscription. To complete the validation handshake, the subscriber must
     * either respond with this validation code as part of the validation
     * response, or perform a GET request on the validationUrl (available
     * starting version 2018-05-01-preview).
     */
    @JsonProperty(value = "validationCode", access = JsonProperty.Access.WRITE_ONLY)
    private String validationCode;

    /**
     * The validation URL sent by Azure Event Grid (available starting version
     * 2018-05-01-preview). To complete the validation handshake, the
     * subscriber must either respond with the validationCode as part of the
     * validation response, or perform a GET request on the validationUrl
     * (available starting version 2018-05-01-preview).
     */
    @JsonProperty(value = "validationUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String validationUrl;

    /**
     * Get the validation code sent by Azure Event Grid to validate an event subscription. To complete the validation handshake, the subscriber must either respond with this validation code as part of the validation response, or perform a GET request on the validationUrl (available starting version 2018-05-01-preview).
     *
     * @return the validationCode value
     */
    public String validationCode() {
        return this.validationCode;
    }

    /**
     * Get the validation URL sent by Azure Event Grid (available starting version 2018-05-01-preview). To complete the validation handshake, the subscriber must either respond with the validationCode as part of the validation response, or perform a GET request on the validationUrl (available starting version 2018-05-01-preview).
     *
     * @return the validationUrl value
     */
    public String validationUrl() {
        return this.validationUrl;
    }

}
