/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.LeaseState;

class AzureBlobLease
extends Lease {
    private transient CloudBlockBlob blob;
    private transient BlobRequestOptions options;
    private String offset = null;
    private long sequenceNumber = 0L;

    AzureBlobLease(String partitionId, CloudBlockBlob blob, BlobRequestOptions options) {
        super(partitionId);
        this.blob = blob;
        this.options = options;
    }

    AzureBlobLease(AzureBlobLease source) {
        super(source);
        this.offset = source.offset;
        this.sequenceNumber = source.sequenceNumber;
        this.blob = source.blob;
        this.options = source.options;
    }

    AzureBlobLease(AzureBlobLease source, CloudBlockBlob blob, BlobRequestOptions options) {
        super(source);
        this.offset = source.offset;
        this.sequenceNumber = source.sequenceNumber;
        this.blob = blob;
        this.options = options;
    }

    AzureBlobLease(Lease source, CloudBlockBlob blob, BlobRequestOptions options) {
        super(source);
        this.blob = blob;
        this.options = options;
    }

    CloudBlockBlob getBlob() {
        return this.blob;
    }

    void setOffset(String offset) {
        this.offset = offset;
    }

    String getOffset() {
        return this.offset;
    }

    void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }

    Checkpoint getCheckpoint() {
        return new Checkpoint(this.getPartitionId(), this.offset, this.sequenceNumber);
    }

    @Override
    public boolean isExpired() throws Exception {
        this.blob.downloadAttributes(null, this.options, null);
        LeaseState currentState = this.blob.getProperties().getLeaseState();
        return currentState != LeaseState.LEASED;
    }

    @Override
    String getStateDebug() {
        String retval = "uninitialized";
        try {
            this.blob.downloadAttributes();
            BlobProperties props = this.blob.getProperties();
            retval = props.getLeaseState().toString() + " " + props.getLeaseStatus().toString() + " " + props.getLeaseDuration().toString();
        }
        catch (StorageException e) {
            retval = "downloadAttributes on the blob caught " + e.toString();
        }
        return retval;
    }
}

