/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.CloseReason;
import com.microsoft.azure.eventprocessorhost.EventHubPartitionPump;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.PartitionPump;
import com.microsoft.azure.eventprocessorhost.PartitionPumpStatus;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;

class Pump {
    protected final EventProcessorHost host;
    private ConcurrentHashMap<String, PartitionPump> pumpStates;

    public Pump(EventProcessorHost host) {
        this.host = host;
        this.pumpStates = new ConcurrentHashMap();
    }

    public void addPump(String partitionId, Lease lease) throws Exception {
        PartitionPump capturedPump = this.pumpStates.get(partitionId);
        if (capturedPump != null) {
            if (capturedPump.getPumpStatus() == PartitionPumpStatus.PP_ERRORED || capturedPump.isClosing().booleanValue()) {
                Future<?> removing = this.removePump(partitionId, CloseReason.Shutdown);
                if (removing != null) {
                    removing.get();
                }
                this.createNewPump(partitionId, lease);
            } else {
                this.host.logWithHostAndPartition(Level.FINER, partitionId, "updating lease for pump");
                capturedPump.setLease(lease);
            }
        } else {
            this.createNewPump(partitionId, lease);
        }
    }

    private void createNewPump(String partitionId, Lease lease) throws Exception {
        EventHubPartitionPump newPartitionPump = new EventHubPartitionPump(this.host, this, lease);
        EventProcessorHost.getExecutorService().submit(() -> newPartitionPump.startPump());
        this.pumpStates.put(partitionId, newPartitionPump);
        this.host.logWithHostAndPartition(Level.FINE, partitionId, "created new pump");
    }

    public Future<?> removePump(String partitionId, CloseReason reason) {
        Future<?> retval = null;
        PartitionPump capturedPump = this.pumpStates.get(partitionId);
        if (capturedPump != null) {
            this.host.logWithHostAndPartition(Level.FINE, partitionId, "closing pump for reason " + reason.toString());
            retval = EventProcessorHost.getExecutorService().submit(() -> capturedPump.shutdown(reason));
            this.host.logWithHostAndPartition(Level.FINE, partitionId, "removing pump");
            this.pumpStates.remove(partitionId);
        } else {
            this.host.logWithHostAndPartition(Level.FINER, partitionId, "no pump found to remove for partition " + partitionId);
        }
        return retval;
    }

    void onPumpError(String partitionId) {
        Future<?> removal = this.removePump(partitionId, CloseReason.Shutdown);
        if (removal != null) {
            try {
                removal.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.host.logWithHostAndPartition(Level.WARNING, partitionId, "error while shutting down failed partition pump", (Throwable)e);
            }
        }
    }

    public Iterable<Future<?>> removeAllPumps(CloseReason reason) {
        ArrayList futures = new ArrayList();
        for (String partitionId : this.pumpStates.keySet()) {
            futures.add(this.removePump(partitionId, reason));
        }
        return futures;
    }

    public boolean hasPump(String partitionId) {
        return this.pumpStates.containsKey(partitionId);
    }
}

