/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.ExceptionReceivedEventArgs;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;

public final class EventProcessorOptions {
    private Consumer<ExceptionReceivedEventArgs> exceptionNotificationHandler = null;
    private Boolean invokeProcessorAfterReceiveTimeout = false;
    private boolean receiverRuntimeMetricEnabled = false;
    private int maxBatchSize = 10;
    private int prefetchCount = 300;
    private Duration receiveTimeOut = Duration.ofMinutes(1L);
    private Function<String, Object> initialOffsetProvider = partitionId -> "-1";

    public static EventProcessorOptions getDefaultOptions() {
        return new EventProcessorOptions();
    }

    public void setExceptionNotification(Consumer<ExceptionReceivedEventArgs> notificationHandler) {
        this.exceptionNotificationHandler = notificationHandler;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public Duration getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    public void setReceiveTimeOut(Duration receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public Function<String, Object> getInitialOffsetProvider() {
        return this.initialOffsetProvider;
    }

    public void setInitialOffsetProvider(Function<String, Object> initialOffsetProvider) {
        this.initialOffsetProvider = initialOffsetProvider;
    }

    public Boolean getInvokeProcessorAfterReceiveTimeout() {
        return this.invokeProcessorAfterReceiveTimeout;
    }

    public void setInvokeProcessorAfterReceiveTimeout(Boolean invokeProcessorAfterReceiveTimeout) {
        this.invokeProcessorAfterReceiveTimeout = invokeProcessorAfterReceiveTimeout;
    }

    public boolean getReceiverRuntimeMetricEnabled() {
        return this.receiverRuntimeMetricEnabled;
    }

    public void setReceiverRuntimeMetricEnabled(boolean value) {
        this.receiverRuntimeMetricEnabled = value;
    }

    void notifyOfException(String hostname, Exception exception, String action) {
        this.notifyOfException(hostname, exception, action, "N/A");
    }

    void notifyOfException(String hostname, Exception exception, String action, String partitionId) {
        Consumer<ExceptionReceivedEventArgs> handler = this.exceptionNotificationHandler;
        if (handler != null) {
            handler.accept(new ExceptionReceivedEventArgs(hostname, exception, action, partitionId));
        }
    }

    public class EndOfStreamInitialOffsetProvider
    implements Function<String, Object> {
        @Override
        public Object apply(String t) {
            return "@latest";
        }
    }

    public class StartOfStreamInitialOffsetProvider
    implements Function<String, Object> {
        @Override
        public Object apply(String t) {
            return "-1";
        }
    }
}

