/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

public class PartitionManagerOptions {
    public static final int DefaultLeaseDurationInSeconds = 30;
    public static final int DefaultLeaseRenewIntervalInSeconds = 10;
    public static final int DefaultCheckpointTimeoutInSeconds = 120;
    protected int leaseDurationInSeconds = 30;
    protected int leaseRenewIntervalInSeconds = 10;
    protected int checkpointTimeoutInSeconds = 120;

    public int getLeaseDurationInSeconds() {
        return this.leaseDurationInSeconds;
    }

    public void setLeaseDurationInSeconds(int duration) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Lease duration must be greater than 0");
        }
        this.leaseDurationInSeconds = duration;
    }

    public int getLeaseRenewIntervalInSeconds() {
        return this.leaseRenewIntervalInSeconds;
    }

    public void setLeaseRenewIntervalInSeconds(int interval) {
        if (interval <= 0 || interval > this.leaseDurationInSeconds) {
            throw new IllegalArgumentException("Lease renew interval must be greater than 0 and not more than lease duration");
        }
        this.leaseRenewIntervalInSeconds = interval;
    }

    public int getCheckpointTimeoutInSeconds() {
        return this.checkpointTimeoutInSeconds;
    }

    public void setCheckpointTimeoutInSeconds(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Checkpoint timeout must be greater than 0");
        }
        this.checkpointTimeoutInSeconds = timeout;
    }
}

