/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.CloseReason;
import com.microsoft.azure.eventprocessorhost.EventHubPartitionPump;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import com.microsoft.azure.eventprocessorhost.PartitionPump;
import com.microsoft.azure.eventprocessorhost.PartitionPumpStatus;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Pump {
    protected final EventProcessorHost host;
    private ConcurrentHashMap<String, PartitionPump> pumpStates;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(Pump.class);

    public Pump(EventProcessorHost host) {
        this.host = host;
        this.pumpStates = new ConcurrentHashMap();
    }

    public void addPump(String partitionId, Lease lease) throws Exception {
        PartitionPump capturedPump = this.pumpStates.get(partitionId);
        if (capturedPump != null) {
            if (capturedPump.getPumpStatus() == PartitionPumpStatus.PP_ERRORED || capturedPump.isClosing().booleanValue()) {
                Future<?> removing = this.removePump(partitionId, CloseReason.Shutdown);
                if (removing != null) {
                    removing.get();
                }
                this.createNewPump(partitionId, lease);
            } else {
                TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "updating lease for pump"));
                capturedPump.setLease(lease);
            }
        } else {
            this.createNewPump(partitionId, lease);
        }
    }

    private void createNewPump(final String partitionId, Lease lease) throws Exception {
        final EventHubPartitionPump newPartitionPump = new EventHubPartitionPump(this.host, this, lease);
        this.host.getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                newPartitionPump.startPump();
                if (newPartitionPump.getPumpStatus() == PartitionPumpStatus.PP_RUNNING) {
                    Pump.this.pumpStates.put(partitionId, newPartitionPump);
                    TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(Pump.this.host.getHostName(), partitionId, "created new pump"));
                }
                return null;
            }
        });
    }

    public Future<?> removePump(String partitionId, CloseReason reason) {
        Future<?> retval = null;
        PartitionPump capturedPump = this.pumpStates.get(partitionId);
        if (capturedPump != null) {
            TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "closing pump for reason " + reason.toString()));
            retval = this.host.getExecutorService().submit(() -> capturedPump.shutdown(reason));
            TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "removing pump"));
            this.pumpStates.remove(partitionId);
        } else {
            TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "no pump found to remove for partition " + partitionId));
        }
        return retval;
    }

    void onPumpError(String partitionId) {
        Future<?> removal = this.removePump(partitionId, CloseReason.Shutdown);
        if (removal != null) {
            try {
                removal.get();
            }
            catch (InterruptedException | ExecutionException e) {
                TRACE_LOGGER.warn(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "error while shutting down failed partition pump"), (Throwable)e);
            }
        }
    }

    public Iterable<Future<?>> removeAllPumps(CloseReason reason) {
        ArrayList futures = new ArrayList();
        for (String partitionId : this.pumpStates.keySet()) {
            futures.add(this.removePump(partitionId, reason));
        }
        return futures;
    }

    public boolean hasPump(String partitionId) {
        return this.pumpStates.containsKey(partitionId);
    }
}

